/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basecrdt.core.internal;

import com.google.common.collect.Maps;
import com.google.protobuf.ByteString;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import org.apache.bifromq.basecrdt.core.internal.DotStore;
import org.apache.bifromq.basecrdt.core.internal.IDotFunc;
import org.apache.bifromq.basecrdt.core.internal.ProtoUtils;
import org.apache.bifromq.basecrdt.proto.Dot;
import org.apache.bifromq.basecrdt.proto.StateLattice;

class DotFunc
extends DotStore
implements IDotFunc {
    public static final IDotFunc BOTTOM = new DotFunc();
    private final Map<Dot, ByteString> dots = Maps.newConcurrentMap();

    DotFunc() {
    }

    @Override
    public Iterator<Dot> iterator() {
        return this.dots.keySet().iterator();
    }

    @Override
    public boolean isBottom() {
        return this.dots.isEmpty();
    }

    @Override
    public Iterable<ByteString> values() {
        return this.dots.values();
    }

    @Override
    public Optional<ByteString> value(Dot dot) {
        return Optional.ofNullable(this.dots.get(dot));
    }

    @Override
    boolean add(StateLattice addState) {
        assert (addState.getStateTypeCase() == StateLattice.StateTypeCase.SINGLEVALUE);
        return this.dots.putIfAbsent(ProtoUtils.dot(addState.getSingleValue().getReplicaId(), addState.getSingleValue().getVer()), addState.getSingleValue().getValue()) == null;
    }

    @Override
    boolean remove(StateLattice removeState) {
        assert (removeState.getStateTypeCase() == StateLattice.StateTypeCase.SINGLEVALUE);
        return this.dots.remove(ProtoUtils.dot(removeState.getSingleValue().getReplicaId(), removeState.getSingleValue().getVer()), removeState.getSingleValue().getValue());
    }

    public String toString() {
        return "DotFunc{dots=" + String.valueOf(this.dots) + "}";
    }
}

