/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.utils;

import org.apache.bifromq.basehlc.HLC;
import org.apache.bifromq.basekv.proto.KVRangeId;

public final class KVRangeIdUtil {
    public static KVRangeId generate() {
        long hlc = HLC.INST.get();
        return KVRangeId.newBuilder().setEpoch(hlc).setId(0L).build();
    }

    public static KVRangeId next(KVRangeId from) {
        return KVRangeIdUtil.next(from.getEpoch());
    }

    public static KVRangeId next(long epoch) {
        return KVRangeId.newBuilder().setEpoch(epoch).setId(HLC.INST.get()).build();
    }

    public static String toString(KVRangeId kvRangeId) {
        return Long.toUnsignedString(kvRangeId.getEpoch()) + "_" + Long.toUnsignedString(kvRangeId.getId());
    }

    public static KVRangeId fromString(String id) {
        String[] parts = id.split("_");
        assert (parts.length == 2);
        return KVRangeId.newBuilder().setEpoch(Long.parseUnsignedLong(parts[0])).setId(Long.parseUnsignedLong(parts[1])).build();
    }
}

