/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.starter.config.model.dist;

import com.fasterxml.jackson.annotation.JsonMerge;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.google.protobuf.Struct;
import com.google.protobuf.Value;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.bifromq.starter.config.model.BalancerOptions;
import org.apache.bifromq.starter.config.model.EngineConfig;
import org.apache.bifromq.starter.config.model.SplitHinterOptions;

public class DistWorkerConfig {
    private boolean enable = true;
    private int workerThreads = 0;
    private int tickerThreads = Math.max(1, Runtime.getRuntime().availableProcessors() / 20);
    private int maxWALFetchSize = 0xA00000;
    private int compactWALThreshold = 0x10000000;
    private int minGCIntervalSeconds = 30;
    private int maxGCIntervalSeconds = 86400;
    @JsonSetter(nulls=Nulls.SKIP)
    @JsonMerge
    private EngineConfig dataEngineConfig = new EngineConfig().setType("rocksdb").setProps((Map<String, Object>)new HashMap<String, Object>(){
        {
            this.put("manualCompaction", true);
            this.put("compactMinTombstoneKeys", 2500);
            this.put("compactMinTombstoneRanges", 2);
        }
    });
    @JsonSetter(nulls=Nulls.SKIP)
    @JsonMerge
    private EngineConfig walEngineConfig = new EngineConfig().setType("rocksdb").setProps((Map<String, Object>)new HashMap<String, Object>(){
        {
            this.put("manualCompaction", true);
            this.put("compactMinTombstoneKeys", 2500);
            this.put("compactMinTombstoneRanges", 2);
        }
    });
    @JsonSetter(nulls=Nulls.SKIP)
    private BalancerOptions balanceConfig = new BalancerOptions();
    @JsonSetter(nulls=Nulls.SKIP)
    private SplitHinterOptions splitHinterConfig = new SplitHinterOptions();
    @JsonSetter(nulls=Nulls.SKIP)
    private Map<String, String> attributes = new HashMap<String, String>();

    public DistWorkerConfig() {
        this.balanceConfig.getBalancers().put("org.apache.bifromq.dist.worker.balance.RangeLeaderBalancerFactory", Struct.getDefaultInstance());
        this.balanceConfig.getBalancers().put("org.apache.bifromq.dist.worker.balance.ReplicaCntBalancerFactory", Struct.newBuilder().putFields("votersPerRange", Value.newBuilder().setNumberValue(3.0).build()).putFields("learnersPerRange", Value.newBuilder().setNumberValue(-1.0).build()).build());
        this.splitHinterConfig.getHinters().put("org.apache.bifromq.dist.worker.hinter.FanoutSplitHinterFactory", Struct.newBuilder().putFields("splitThreshold", Value.newBuilder().setNumberValue(100000.0).build()).build());
        this.splitHinterConfig.getHinters().put("org.apache.bifromq.basekv.store.range.hinter.MutationKVLoadBasedSplitHinterFactory", Struct.newBuilder().putFields("windowSeconds", Value.newBuilder().setNumberValue(5.0).build()).build());
    }

    @Generated
    public boolean isEnable() {
        return this.enable;
    }

    @Generated
    public int getWorkerThreads() {
        return this.workerThreads;
    }

    @Generated
    public int getTickerThreads() {
        return this.tickerThreads;
    }

    @Generated
    public int getMaxWALFetchSize() {
        return this.maxWALFetchSize;
    }

    @Generated
    public int getCompactWALThreshold() {
        return this.compactWALThreshold;
    }

    @Generated
    public int getMinGCIntervalSeconds() {
        return this.minGCIntervalSeconds;
    }

    @Generated
    public int getMaxGCIntervalSeconds() {
        return this.maxGCIntervalSeconds;
    }

    @Generated
    public EngineConfig getDataEngineConfig() {
        return this.dataEngineConfig;
    }

    @Generated
    public EngineConfig getWalEngineConfig() {
        return this.walEngineConfig;
    }

    @Generated
    public BalancerOptions getBalanceConfig() {
        return this.balanceConfig;
    }

    @Generated
    public SplitHinterOptions getSplitHinterConfig() {
        return this.splitHinterConfig;
    }

    @Generated
    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    @Generated
    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    @Generated
    public void setWorkerThreads(int workerThreads) {
        this.workerThreads = workerThreads;
    }

    @Generated
    public void setTickerThreads(int tickerThreads) {
        this.tickerThreads = tickerThreads;
    }

    @Generated
    public void setMaxWALFetchSize(int maxWALFetchSize) {
        this.maxWALFetchSize = maxWALFetchSize;
    }

    @Generated
    public void setCompactWALThreshold(int compactWALThreshold) {
        this.compactWALThreshold = compactWALThreshold;
    }

    @Generated
    public void setMinGCIntervalSeconds(int minGCIntervalSeconds) {
        this.minGCIntervalSeconds = minGCIntervalSeconds;
    }

    @Generated
    public void setMaxGCIntervalSeconds(int maxGCIntervalSeconds) {
        this.maxGCIntervalSeconds = maxGCIntervalSeconds;
    }

    @JsonSetter(nulls=Nulls.SKIP)
    @Generated
    public void setDataEngineConfig(EngineConfig dataEngineConfig) {
        this.dataEngineConfig = dataEngineConfig;
    }

    @JsonSetter(nulls=Nulls.SKIP)
    @Generated
    public void setWalEngineConfig(EngineConfig walEngineConfig) {
        this.walEngineConfig = walEngineConfig;
    }

    @JsonSetter(nulls=Nulls.SKIP)
    @Generated
    public void setBalanceConfig(BalancerOptions balanceConfig) {
        this.balanceConfig = balanceConfig;
    }

    @JsonSetter(nulls=Nulls.SKIP)
    @Generated
    public void setSplitHinterConfig(SplitHinterOptions splitHinterConfig) {
        this.splitHinterConfig = splitHinterConfig;
    }

    @JsonSetter(nulls=Nulls.SKIP)
    @Generated
    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }
}

