/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.plugin.settingprovider;

import java.util.function.BiPredicate;
import java.util.function.Predicate;
import lombok.Generated;
import org.apache.bifromq.plugin.settingprovider.ISettingProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Setting
extends Enum<Setting> {
    public static final /* enum */ Setting MQTT3Enabled = new Setting(Boolean.class, val -> true, (Object)true);
    public static final /* enum */ Setting MQTT4Enabled = new Setting(Boolean.class, val -> true, (Object)true);
    public static final /* enum */ Setting MQTT5Enabled = new Setting(Boolean.class, val -> true, (Object)true);
    public static final /* enum */ Setting NoLWTWhenServerShuttingDown = new Setting(Boolean.class, val -> true, (Object)true);
    public static final /* enum */ Setting DebugModeEnabled = new Setting(Boolean.class, val -> true, (Object)false);
    public static final /* enum */ Setting ForceTransient = new Setting(Boolean.class, val -> true, (Object)false);
    public static final /* enum */ Setting ByPassPermCheckError = new Setting(Boolean.class, val -> true, (Object)true);
    public static final /* enum */ Setting PayloadFormatValidationEnabled = new Setting(Boolean.class, val -> true, (Object)true);
    public static final /* enum */ Setting RetainEnabled = new Setting(Boolean.class, val -> true, (Object)true);
    public static final /* enum */ Setting WildcardSubscriptionEnabled = new Setting(Boolean.class, val -> true, (Object)true);
    public static final /* enum */ Setting SubscriptionIdentifierEnabled = new Setting(Boolean.class, val -> true, (Object)true);
    public static final /* enum */ Setting SharedSubscriptionEnabled = new Setting(Boolean.class, val -> true, (Object)true);
    public static final /* enum */ Setting MaximumQoS = new Setting(Integer.class, val -> (Integer)val == 0 || (Integer)val == 1 || (Integer)val == 2, (Object)2);
    public static final /* enum */ Setting MaxTopicLevelLength = new Setting(Integer.class, val -> (Integer)val > 0, (Object)40);
    public static final /* enum */ Setting MaxTopicLevels = new Setting(Integer.class, val -> (Integer)val > 0, (Object)16);
    public static final /* enum */ Setting MaxTopicLength = new Setting(Integer.class, val -> (Integer)val > 0 && (Integer)val < 65536, (Object)255);
    public static final /* enum */ Setting MaxTopicAlias = new Setting(Integer.class, val -> (Integer)val >= 0 && (Integer)val < 65536, (Object)10);
    public static final /* enum */ Setting MaxSharedGroupMembers = new Setting(Integer.class, val -> (Integer)val > 0, (Object)200);
    public static final /* enum */ Setting MaxTopicFiltersPerInbox = new Setting(Integer.class, val -> (Integer)val > 0, (Object)100);
    public static final /* enum */ Setting MsgPubPerSec = new Setting(Integer.class, val -> (Integer)val > 0 && (Integer)val <= 1000, (Object)200);
    public static final /* enum */ Setting ReceivingMaximum = new Setting(Integer.class, val -> (Integer)val > 0 && (Integer)val <= 65535, (Object)200);
    public static final /* enum */ Setting InBoundBandWidth = new Setting(Long.class, val -> (Long)val >= 0L, (Object)524288L);
    public static final /* enum */ Setting OutBoundBandWidth = new Setting(Long.class, val -> (Long)val >= 0L, (Object)524288L);
    public static final /* enum */ Setting MaxLastWillBytes = new Setting(Integer.class, val -> (Integer)val > 0 && (Integer)val <= 0xFA00000, (Object)128);
    public static final /* enum */ Setting MaxUserPayloadBytes = new Setting(Integer.class, val -> (Integer)val > 0 && (Integer)val <= 0x10000000, (Object)262144);
    public static final /* enum */ Setting MinSendPerSec = new Setting(Integer.class, val -> (Integer)val > 0, (Object)8);
    public static final /* enum */ Setting MaxResendTimes = new Setting(Integer.class, val -> (Integer)val >= 0, (Object)3);
    public static final /* enum */ Setting ResendTimeoutSeconds = new Setting(Integer.class, val -> (Integer)val > 0, (Object)10);
    public static final /* enum */ Setting MaxTopicFiltersPerSub = new Setting(Integer.class, val -> (Integer)val > 0 && (Integer)val <= 100, (Object)10);
    public static final /* enum */ Setting MaxGroupFanout = new Setting(Integer.class, val -> (Integer)val > 0, (Object)100);
    public static final /* enum */ Setting MaxPersistentFanout = new Setting(Integer.class, val -> (Integer)val > 0, (Object)Integer.MAX_VALUE);
    public static final /* enum */ Setting MaxPersistentFanoutBytes = new Setting(Long.class, val -> (Long)val > 0L, (Object)Long.MAX_VALUE);
    public static final /* enum */ Setting MaxSessionExpirySeconds = new Setting(Integer.class, val -> (Integer)val > 0 && Integer.compareUnsigned((Integer)val, -1) <= 0, (Object)86400);
    public static final /* enum */ Setting MinSessionExpirySeconds = new Setting(Integer.class, (val, tenantId) -> {
        int maxSEI = tenantId == null ? ((Integer)MaxSessionExpirySeconds.initialValue()).intValue() : ((Integer)MaxSessionExpirySeconds.current((String)tenantId)).intValue();
        return (Integer)val > 0 && Integer.compareUnsigned((Integer)val, maxSEI) <= 0;
    }, (Object)60);
    public static final /* enum */ Setting MinKeepAliveSeconds = new Setting(Integer.class, val -> (Integer)val > 0 && (Integer)val < 65535, (Object)60);
    public static final /* enum */ Setting SessionInboxSize = new Setting(Integer.class, val -> (Integer)val > 0 && (Integer)val <= 65535, (Object)1000);
    public static final /* enum */ Setting QoS0DropOldest = new Setting(Boolean.class, val -> true, (Object)false);
    public static final /* enum */ Setting RetainMessageMatchLimit = new Setting(Integer.class, val -> (Integer)val >= 0, (Object)10);
    @Generated
    private static final Logger log;
    public final Class<?> valueType;
    private final BiPredicate<Object, String> validator;
    private final Object defVal;
    private volatile ISettingProvider settingProvider;
    private static final /* synthetic */ Setting[] $VALUES;

    public static Setting[] values() {
        return (Setting[])$VALUES.clone();
    }

    public static Setting valueOf(String name) {
        return Enum.valueOf(Setting.class, name);
    }

    private Setting(Class<?> valueType, Predicate<Object> validator, Object defValue) {
        this(valueType, (Object val, String tenantId) -> validator.test(val), defValue);
    }

    private Setting(Class<?> valueType, BiPredicate<Object, String> validator, Object defValue) {
        this.valueType = valueType;
        this.validator = validator;
        this.defVal = this.resolve(defValue);
        assert (this.isValid(this.defVal, null));
    }

    public <R> R current(String tenantId) {
        return this.settingProvider == null ? this.initialValue() : this.settingProvider.provide(this, tenantId);
    }

    public <R> boolean isValid(R val, String tenantId) {
        if (!this.valueType.isInstance(val)) {
            return false;
        }
        return this.validator.test(val, tenantId);
    }

    <R> R initialValue() {
        return (R)this.defVal;
    }

    void setProvider(ISettingProvider provider) {
        this.settingProvider = provider;
    }

    Object resolve(Object initial) {
        String override = System.getProperty(this.name());
        if (override != null) {
            try {
                if (this.valueType == Integer.class) {
                    return Integer.parseInt(override);
                }
                if (this.valueType == Long.class) {
                    return Long.parseLong(override);
                }
                if (this.valueType == Boolean.class) {
                    return Boolean.parseBoolean(override);
                }
            }
            catch (Throwable e) {
                log.error("Unable to parse setting value from system property: setting={}, value={}", (Object)this.name(), (Object)override);
                return initial;
            }
        }
        return initial;
    }

    private static /* synthetic */ Setting[] $values() {
        return new Setting[]{MQTT3Enabled, MQTT4Enabled, MQTT5Enabled, NoLWTWhenServerShuttingDown, DebugModeEnabled, ForceTransient, ByPassPermCheckError, PayloadFormatValidationEnabled, RetainEnabled, WildcardSubscriptionEnabled, SubscriptionIdentifierEnabled, SharedSubscriptionEnabled, MaximumQoS, MaxTopicLevelLength, MaxTopicLevels, MaxTopicLength, MaxTopicAlias, MaxSharedGroupMembers, MaxTopicFiltersPerInbox, MsgPubPerSec, ReceivingMaximum, InBoundBandWidth, OutBoundBandWidth, MaxLastWillBytes, MaxUserPayloadBytes, MinSendPerSec, MaxResendTimes, ResendTimeoutSeconds, MaxTopicFiltersPerSub, MaxGroupFanout, MaxPersistentFanout, MaxPersistentFanoutBytes, MaxSessionExpirySeconds, MinSessionExpirySeconds, MinKeepAliveSeconds, SessionInboxSize, QoS0DropOldest, RetainMessageMatchLimit};
    }

    static {
        $VALUES = Setting.$values();
        log = LoggerFactory.getLogger(Setting.class);
    }
}

