/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.apiserver.http.handler.utils;

import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpRequest;
import java.util.HashMap;
import java.util.Map;
import org.apache.bifromq.apiserver.Headers;
import org.apache.bifromq.basehlc.HLC;
import org.apache.bifromq.type.QoS;

public final class HeaderUtils {
    public static long getOptionalReqId(FullHttpRequest req) {
        String headerText = HeaderUtils.getHeader(Headers.HEADER_REQ_ID, (HttpRequest)req, false);
        if (headerText == null) {
            return HLC.INST.get();
        }
        try {
            return Long.parseLong(headerText);
        }
        catch (Throwable e) {
            return HLC.INST.get();
        }
    }

    public static QoS getRequiredSubQoS(HttpRequest req) {
        String subQoS = HeaderUtils.getHeader(Headers.HEADER_SUB_QOS, req, true);
        QoS qos = QoS.forNumber((int)Integer.parseInt(subQoS));
        if (qos == null) {
            throw new IllegalArgumentException("Invalid sub qos: " + subQoS);
        }
        return qos;
    }

    public static Map<String, String> getClientMeta(HttpRequest req) {
        HashMap<String, String> clientMeta = new HashMap<String, String>();
        for (Map.Entry entry : req.headers()) {
            if (!((String)entry.getKey()).startsWith(Headers.HEADER_CLIENT_META_PREFIX.header)) continue;
            clientMeta.put(((String)entry.getKey()).substring(Headers.HEADER_CLIENT_META_PREFIX.header.length()), (String)entry.getValue());
        }
        return clientMeta;
    }

    public static String getHeader(Headers header, HttpRequest req, boolean required) {
        String headerText = req.headers().get(header.header);
        if (headerText == null && required) {
            throw new IllegalArgumentException("header not found: " + String.valueOf((Object)header));
        }
        return headerText;
    }
}

