/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.baserpc.client.nameresolver;

import io.grpc.Attributes;
import io.grpc.EquivalentAddressGroup;
import io.grpc.NameResolver;
import io.grpc.Status;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.ObservableSource;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.bifromq.baserpc.client.loadbalancer.Constants;
import org.apache.bifromq.baserpc.trafficgovernor.IRPCServiceLandscape;
import org.apache.bifromq.baserpc.trafficgovernor.ServerEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TrafficGovernorNameResolver
extends NameResolver {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TrafficGovernorNameResolver.class);
    private final String serviceUniqueName;
    private final IRPCServiceLandscape trafficDirector;
    private final CompositeDisposable disposable = new CompositeDisposable();

    public TrafficGovernorNameResolver(String serviceUniqueName, IRPCServiceLandscape trafficDirector) {
        this.serviceUniqueName = serviceUniqueName;
        this.trafficDirector = trafficDirector;
    }

    public String getServiceAuthority() {
        return this.serviceUniqueName;
    }

    public void start(NameResolver.Listener listener) {
        log.debug("Starting TrafficGovernorNameResolver for service[{}]", (Object)this.serviceUniqueName);
        this.disposable.add(Observable.combineLatest((ObservableSource)this.trafficDirector.trafficRules(), (ObservableSource)this.trafficDirector.serverEndpoints(), (td, sl) -> {
            log.debug("Service[{}] landscape update:td={}, sl={}", new Object[]{this.serviceUniqueName, td, sl});
            return () -> listener.onAddresses(this.toAddressGroup((Set<ServerEndpoint>)sl), this.toAttributes((Map<String, Map<String, Integer>>)td));
        }).subscribe(Runnable::run, e -> listener.onError(Status.INTERNAL.withCause(e))));
    }

    public void shutdown() {
        log.debug("Shutting down trafficGovernor nameResolver, service={}", (Object)this.serviceUniqueName);
        this.disposable.dispose();
    }

    public void refresh() {
    }

    private List<EquivalentAddressGroup> toAddressGroup(Set<ServerEndpoint> serverEndpoints) {
        return serverEndpoints.stream().map(s -> new EquivalentAddressGroup(s.hostAddr(), Attributes.newBuilder().set(Constants.SERVER_ID_ATTR_KEY, (Object)s.id()).set(Constants.SERVER_GROUP_TAG_ATTR_KEY, (Object)s.groupTags()).set(Constants.IN_PROC_SERVER_ATTR_KEY, (Object)s.inProc()).build())).collect(Collectors.toList());
    }

    private Attributes toAttributes(Map<String, Map<String, Integer>> td) {
        return Attributes.newBuilder().set(Constants.TRAFFIC_DIRECTIVE_ATTR_KEY, td).build();
    }
}

