/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.grpc.CallbackMetricInstrument;
import io.grpc.DoubleCounterMetricInstrument;
import io.grpc.DoubleHistogramMetricInstrument;
import io.grpc.LongCounterMetricInstrument;
import io.grpc.LongGaugeMetricInstrument;
import io.grpc.LongHistogramMetricInstrument;
import io.grpc.LongUpDownCounterMetricInstrument;
import io.grpc.MetricInstrumentRegistry;
import io.grpc.MetricRecorder;
import io.grpc.MetricSink;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;

final class MetricRecorderImpl
implements MetricRecorder {
    private final List<MetricSink> metricSinks;
    private final MetricInstrumentRegistry registry;

    @VisibleForTesting
    MetricRecorderImpl(List<MetricSink> metricSinks, MetricInstrumentRegistry registry) {
        this.metricSinks = metricSinks;
        this.registry = registry;
    }

    public void addDoubleCounter(DoubleCounterMetricInstrument metricInstrument, double value, List<String> requiredLabelValues, List<String> optionalLabelValues) {
        super.addDoubleCounter(metricInstrument, value, requiredLabelValues, optionalLabelValues);
        for (MetricSink sink : this.metricSinks) {
            int measuresSize = sink.getMeasuresSize();
            if (measuresSize <= metricInstrument.getIndex()) {
                sink.updateMeasures(this.registry.getMetricInstruments());
            }
            sink.addDoubleCounter(metricInstrument, value, requiredLabelValues, optionalLabelValues);
        }
    }

    public void addLongCounter(LongCounterMetricInstrument metricInstrument, long value, List<String> requiredLabelValues, List<String> optionalLabelValues) {
        super.addLongCounter(metricInstrument, value, requiredLabelValues, optionalLabelValues);
        for (MetricSink sink : this.metricSinks) {
            int measuresSize = sink.getMeasuresSize();
            if (measuresSize <= metricInstrument.getIndex()) {
                sink.updateMeasures(this.registry.getMetricInstruments());
            }
            sink.addLongCounter(metricInstrument, value, requiredLabelValues, optionalLabelValues);
        }
    }

    public void addLongUpDownCounter(LongUpDownCounterMetricInstrument metricInstrument, long value, List<String> requiredLabelValues, List<String> optionalLabelValues) {
        super.addLongUpDownCounter(metricInstrument, value, requiredLabelValues, optionalLabelValues);
        for (MetricSink sink : this.metricSinks) {
            int measuresSize = sink.getMeasuresSize();
            if (measuresSize <= metricInstrument.getIndex()) {
                sink.updateMeasures(this.registry.getMetricInstruments());
            }
            sink.addLongUpDownCounter(metricInstrument, value, requiredLabelValues, optionalLabelValues);
        }
    }

    public void recordDoubleHistogram(DoubleHistogramMetricInstrument metricInstrument, double value, List<String> requiredLabelValues, List<String> optionalLabelValues) {
        super.recordDoubleHistogram(metricInstrument, value, requiredLabelValues, optionalLabelValues);
        for (MetricSink sink : this.metricSinks) {
            int measuresSize = sink.getMeasuresSize();
            if (measuresSize <= metricInstrument.getIndex()) {
                sink.updateMeasures(this.registry.getMetricInstruments());
            }
            sink.recordDoubleHistogram(metricInstrument, value, requiredLabelValues, optionalLabelValues);
        }
    }

    public void recordLongHistogram(LongHistogramMetricInstrument metricInstrument, long value, List<String> requiredLabelValues, List<String> optionalLabelValues) {
        super.recordLongHistogram(metricInstrument, value, requiredLabelValues, optionalLabelValues);
        for (MetricSink sink : this.metricSinks) {
            int measuresSize = sink.getMeasuresSize();
            if (measuresSize <= metricInstrument.getIndex()) {
                sink.updateMeasures(this.registry.getMetricInstruments());
            }
            sink.recordLongHistogram(metricInstrument, value, requiredLabelValues, optionalLabelValues);
        }
    }

    public MetricRecorder.Registration registerBatchCallback(MetricRecorder.BatchCallback callback, CallbackMetricInstrument ... metricInstruments) {
        long largestMetricInstrumentIndex = -1L;
        BitSet allowedInstruments = new BitSet();
        for (CallbackMetricInstrument metricInstrument : metricInstruments) {
            largestMetricInstrumentIndex = Math.max(largestMetricInstrumentIndex, (long)metricInstrument.getIndex());
            allowedInstruments.set(metricInstrument.getIndex());
        }
        ArrayList<MetricSink.Registration> registrations = new ArrayList<MetricSink.Registration>();
        for (MetricSink sink : this.metricSinks) {
            int measuresSize = sink.getMeasuresSize();
            if ((long)measuresSize <= largestMetricInstrumentIndex) {
                sink.updateMeasures(this.registry.getMetricInstruments());
            }
            BatchRecorderImpl singleSinkRecorder = new BatchRecorderImpl(sink, allowedInstruments);
            registrations.add(sink.registerBatchCallback(() -> callback.accept(singleSinkRecorder), metricInstruments));
        }
        return () -> {
            for (MetricSink.Registration registration : registrations) {
                registration.close();
            }
        };
    }

    static class BatchRecorderImpl
    implements MetricRecorder.BatchRecorder {
        private final MetricSink sink;
        private final BitSet allowedInstruments;

        BatchRecorderImpl(MetricSink sink, BitSet allowedInstruments) {
            this.sink = (MetricSink)Preconditions.checkNotNull((Object)sink, (Object)"sink");
            this.allowedInstruments = (BitSet)Preconditions.checkNotNull((Object)allowedInstruments, (Object)"allowedInstruments");
        }

        public void recordLongGauge(LongGaugeMetricInstrument metricInstrument, long value, List<String> requiredLabelValues, List<String> optionalLabelValues) {
            super.recordLongGauge(metricInstrument, value, requiredLabelValues, optionalLabelValues);
            Preconditions.checkArgument((boolean)this.allowedInstruments.get(metricInstrument.getIndex()), (String)"Instrument was not listed when registering callback: %s", (Object)metricInstrument);
            this.sink.recordLongGauge(metricInstrument, value, requiredLabelValues, optionalLabelValues);
        }
    }
}

