/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluss.lake.paimon;

import java.util.LinkedHashMap;
import java.util.List;
import org.apache.fluss.annotation.VisibleForTesting;
import org.apache.fluss.config.Configuration;
import org.apache.fluss.exception.TableAlreadyExistException;
import org.apache.fluss.exception.TableNotExistException;
import org.apache.fluss.lake.lakestorage.LakeCatalog;
import org.apache.fluss.lake.paimon.utils.PaimonConversions;
import org.apache.fluss.metadata.TableChange;
import org.apache.fluss.metadata.TableDescriptor;
import org.apache.fluss.metadata.TablePath;
import org.apache.fluss.utils.IOUtils;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.catalog.CatalogContext;
import org.apache.paimon.catalog.CatalogFactory;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.options.Options;
import org.apache.paimon.schema.Schema;
import org.apache.paimon.schema.SchemaChange;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypes;

public class PaimonLakeCatalog
implements LakeCatalog {
    public static final LinkedHashMap<String, DataType> SYSTEM_COLUMNS = new LinkedHashMap();
    private final Catalog paimonCatalog;

    public PaimonLakeCatalog(Configuration configuration) {
        this.paimonCatalog = CatalogFactory.createCatalog(CatalogContext.create(Options.fromMap(configuration.toMap())));
    }

    @VisibleForTesting
    protected Catalog getPaimonCatalog() {
        return this.paimonCatalog;
    }

    public void createTable(TablePath tablePath, TableDescriptor tableDescriptor) throws TableAlreadyExistException {
        Identifier paimonPath = PaimonConversions.toPaimon(tablePath);
        Schema paimonSchema = PaimonConversions.toPaimonSchema(tableDescriptor);
        try {
            this.createTable(paimonPath, paimonSchema);
        }
        catch (Catalog.DatabaseNotExistException e) {
            this.createDatabase(tablePath.getDatabaseName());
            try {
                this.createTable(paimonPath, paimonSchema);
            }
            catch (Catalog.DatabaseNotExistException t) {
                throw new RuntimeException(String.format("Fail to create table %s in Paimon, because Database %s still doesn't exist although create database successfully, please try again.", tablePath, tablePath.getDatabaseName()));
            }
        }
    }

    public void alterTable(TablePath tablePath, List<TableChange> tableChanges) throws TableNotExistException {
        try {
            Identifier paimonPath = PaimonConversions.toPaimon(tablePath);
            List<SchemaChange> paimonSchemaChanges = PaimonConversions.toPaimonSchemaChanges(tableChanges);
            this.alterTable(paimonPath, paimonSchemaChanges);
        }
        catch (Catalog.ColumnAlreadyExistException | Catalog.ColumnNotExistException e) {
            throw new RuntimeException(e);
        }
    }

    private void createTable(Identifier tablePath, Schema schema) throws Catalog.DatabaseNotExistException {
        try {
            this.paimonCatalog.createTable(tablePath, schema, false);
        }
        catch (Catalog.TableAlreadyExistException e) {
            throw new TableAlreadyExistException("Table " + String.valueOf(tablePath) + " already exists.");
        }
    }

    private void createDatabase(String databaseName) {
        try {
            this.paimonCatalog.createDatabase(databaseName, true);
        }
        catch (Catalog.DatabaseAlreadyExistException databaseAlreadyExistException) {
            // empty catch block
        }
    }

    private void alterTable(Identifier tablePath, List<SchemaChange> tableChanges) throws Catalog.ColumnAlreadyExistException, Catalog.ColumnNotExistException {
        try {
            this.paimonCatalog.alterTable(tablePath, tableChanges, false);
        }
        catch (Catalog.TableNotExistException e) {
            throw new TableNotExistException("Table " + String.valueOf(tablePath) + " not exists.");
        }
    }

    public void close() {
        IOUtils.closeQuietly((AutoCloseable)this.paimonCatalog, (String)"paimon catalog");
    }

    static {
        SYSTEM_COLUMNS.put("__bucket", DataTypes.INT());
        SYSTEM_COLUMNS.put("__offset", DataTypes.BIGINT());
        SYSTEM_COLUMNS.put("__timestamp", DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE());
    }
}

