/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.iceberg.migrate;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.paimon.catalog.CatalogContext;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.client.ClientPool;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.hive.HiveCatalog;
import org.apache.paimon.hive.pool.CachedClientPool;
import org.apache.paimon.iceberg.IcebergOptions;
import org.apache.paimon.iceberg.metadata.IcebergMetadata;
import org.apache.paimon.iceberg.migrate.IcebergMigrateMetadata;
import org.apache.paimon.options.Options;
import org.apache.paimon.utils.Preconditions;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IcebergMigrateHiveMetadata
implements IcebergMigrateMetadata {
    private static final Logger LOG = LoggerFactory.getLogger(IcebergMigrateHiveMetadata.class);
    public static final String TABLE_TYPE_PROP = "table_type";
    public static final String ICEBERG_TABLE_TYPE_VALUE = "iceberg";
    private static final String ICEBERG_METADATA_LOCATION = "metadata_location";
    private FileIO fileIO;
    private final Options icebergOptions;
    private final Identifier icebergIdentifier;
    private final ClientPool<IMetaStoreClient, TException> clients;
    private String metadataLocation = null;
    private IcebergMetadata icebergMetadata;

    public IcebergMigrateHiveMetadata(Identifier icebergIdentifier, Options icebergOptions) {
        this.icebergIdentifier = icebergIdentifier;
        this.icebergOptions = icebergOptions;
        String uri = icebergOptions.get(IcebergOptions.URI);
        String hiveConfDir = icebergOptions.get(IcebergOptions.HIVE_CONF_DIR);
        String hadoopConfDir = icebergOptions.get(IcebergOptions.HADOOP_CONF_DIR);
        Configuration hadoopConf = new Configuration();
        hadoopConf.setClassLoader(IcebergMigrateHiveMetadata.class.getClassLoader());
        HiveConf hiveConf = HiveCatalog.createHiveConf(hiveConfDir, hadoopConfDir, hadoopConf);
        icebergOptions.toMap().forEach((arg_0, arg_1) -> ((HiveConf)hiveConf).set(arg_0, arg_1));
        if (uri != null) {
            hiveConf.set(HiveConf.ConfVars.METASTOREURIS.varname, uri);
        }
        if (hiveConf.get(HiveConf.ConfVars.METASTOREURIS.varname) == null) {
            LOG.error("Can't find hive metastore uri to connect: either set {} in iceberg options or set hive.metastore.uris in hive-site.xml or hadoop configurations. Will use empty metastore uris, which means we may use a embedded metastore. Please make sure hive metastore uri for iceberg table is correctly set as expected.", (Object)IcebergOptions.URI.key());
        }
        this.clients = new CachedClientPool((Configuration)hiveConf, icebergOptions, icebergOptions.getString(IcebergOptions.HIVE_CLIENT_CLASS));
    }

    @Override
    public IcebergMetadata icebergMetadata() {
        try {
            boolean isExist = this.tableExists(this.icebergIdentifier);
            if (!isExist) {
                throw new RuntimeException(String.format("iceberg table %s is not existed in hive metastore", this.icebergIdentifier));
            }
            Table icebergHiveTable = this.clients.run(client -> client.getTable(this.icebergIdentifier.getDatabaseName(), this.icebergIdentifier.getTableName()));
            String tableType = (String)icebergHiveTable.getParameters().get(TABLE_TYPE_PROP);
            Preconditions.checkArgument(tableType != null && tableType.equalsIgnoreCase(ICEBERG_TABLE_TYPE_VALUE), "not an iceberg table: %s (table-type=%s)", this.icebergIdentifier.toString(), tableType);
            this.metadataLocation = (String)icebergHiveTable.getParameters().get(ICEBERG_METADATA_LOCATION);
            LOG.info("iceberg latest metadata location: {}", (Object)this.metadataLocation);
            this.fileIO = FileIO.get(new Path(this.metadataLocation), CatalogContext.create(this.icebergOptions));
            this.icebergMetadata = IcebergMetadata.fromPath(this.fileIO, new Path(this.metadataLocation));
            return this.icebergMetadata;
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Failed to read Iceberg metadata from path %s", this.metadataLocation), e);
        }
    }

    @Override
    public String icebergLatestMetadataLocation() {
        return this.metadataLocation;
    }

    @Override
    public void deleteOriginTable() {
        LOG.info("Iceberg table in hive to be deleted:{}", (Object)this.icebergIdentifier.toString());
        try {
            this.clients.run(client -> {
                client.dropTable(this.icebergIdentifier.getDatabaseName(), this.icebergIdentifier.getTableName(), true, true);
                return null;
            });
            Path icebergTablePath = new Path(this.icebergMetadata.location());
            if (this.fileIO.exists(icebergTablePath) && this.fileIO.isDir(icebergTablePath)) {
                this.fileIO.deleteDirectoryQuietly(icebergTablePath);
            }
        }
        catch (Exception e) {
            LOG.warn("exception occurred when deleting origin table", (Throwable)e);
        }
    }

    private boolean tableExists(Identifier identifier) throws Exception {
        return this.clients.run(client -> client.tableExists(identifier.getDatabaseName(), identifier.getTableName()));
    }
}

