/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.rest;

import java.io.IOException;
import org.apache.paimon.shade.okhttp3.Interceptor;
import org.apache.paimon.shade.okhttp3.Request;
import org.apache.paimon.shade.okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingInterceptor
implements Interceptor {
    private static final Logger LOG = LoggerFactory.getLogger(LoggingInterceptor.class);
    public static final String REQUEST_ID_KEY = "x-request-id";
    public static final String DEFAULT_REQUEST_ID = "unknown";

    @Override
    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        long startTime = System.nanoTime();
        Response response = chain.proceed(request);
        long durationMs = (System.nanoTime() - startTime) / 1000000L;
        String requestId = response.header(REQUEST_ID_KEY, DEFAULT_REQUEST_ID);
        LOG.info("[rest] requestId:{} method:{} url:{} duration:{}ms", new Object[]{requestId, request.method(), request.url(), durationMs});
        return response;
    }
}

