/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.rest;

import java.util.regex.Pattern;
import org.apache.paimon.utils.StringUtils;

public class RESTFunctionValidator {
    private static final Pattern FUNCTION_NAME_PATTERN = Pattern.compile("^(?=.*[A-Za-z])[A-Za-z0-9._-]+$");

    public static boolean isValidFunctionName(String name) {
        return StringUtils.isNotEmpty(name) && FUNCTION_NAME_PATTERN.matcher(name).matches();
    }

    public static void checkFunctionName(String name) {
        boolean isValid = RESTFunctionValidator.isValidFunctionName(name);
        if (!isValid) {
            throw new IllegalArgumentException("Invalid function name: " + name);
        }
    }
}

