/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.rest.auth;

import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown=true)
public class DLFToken {
    public static final DateTimeFormatter TOKEN_DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private static final String ACCESS_KEY_ID_FIELD_NAME = "AccessKeyId";
    private static final String ACCESS_KEY_SECRET_FIELD_NAME = "AccessKeySecret";
    private static final String SECURITY_TOKEN_FIELD_NAME = "SecurityToken";
    private static final String EXPIRATION_FIELD_NAME = "Expiration";
    @JsonProperty(value="AccessKeyId")
    private final String accessKeyId;
    @JsonProperty(value="AccessKeySecret")
    private final String accessKeySecret;
    @JsonProperty(value="SecurityToken")
    private final String securityToken;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="Expiration")
    @Nullable
    private final String expiration;
    @JsonIgnore
    @Nullable
    private final Long expirationAtMills;

    @JsonCreator
    public DLFToken(@JsonProperty(value="AccessKeyId") String accessKeyId, @JsonProperty(value="AccessKeySecret") String accessKeySecret, @JsonProperty(value="SecurityToken") String securityToken, @Nullable @JsonProperty(value="Expiration") String expiration) {
        this.accessKeyId = accessKeyId;
        this.accessKeySecret = accessKeySecret;
        this.securityToken = securityToken;
        this.expiration = expiration;
        if (expiration == null) {
            this.expirationAtMills = null;
        } else {
            LocalDateTime dateTime = LocalDateTime.parse(expiration, TOKEN_DATE_FORMATTER);
            this.expirationAtMills = dateTime.atZone(ZoneOffset.UTC).toInstant().toEpochMilli();
        }
    }

    public String getAccessKeyId() {
        return this.accessKeyId;
    }

    public String getAccessKeySecret() {
        return this.accessKeySecret;
    }

    public String getSecurityToken() {
        return this.securityToken;
    }

    @Nullable
    public Long getExpirationAtMills() {
        return this.expirationAtMills;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DLFToken that = (DLFToken)o;
        return Objects.equals(this.accessKeyId, that.accessKeyId) && Objects.equals(this.accessKeySecret, that.accessKeySecret) && Objects.equals(this.securityToken, that.securityToken) && Objects.equals(this.expiration, that.expiration);
    }

    public int hashCode() {
        return Objects.hash(this.accessKeyId, this.accessKeySecret, this.securityToken, this.expiration);
    }
}

