/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.sink;

import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.options.Options;
import org.apache.paimon.table.InnerTable;
import org.apache.paimon.table.sink.BatchTableCommit;
import org.apache.paimon.table.sink.BatchTableWrite;
import org.apache.paimon.table.sink.BatchWriteBuilder;
import org.apache.paimon.table.sink.InnerTableCommit;
import org.apache.paimon.table.sink.WriteSelector;
import org.apache.paimon.types.RowType;

public class BatchWriteBuilderImpl
implements BatchWriteBuilder {
    private static final long serialVersionUID = 1L;
    private final InnerTable table;
    private final String commitUser;
    private Map<String, String> staticPartition;

    public BatchWriteBuilderImpl(InnerTable table) {
        this.table = table;
        this.commitUser = CoreOptions.createCommitUser(new Options(table.options()));
    }

    @Override
    public String tableName() {
        return this.table.name();
    }

    @Override
    public RowType rowType() {
        return this.table.rowType();
    }

    @Override
    public Optional<WriteSelector> newWriteSelector() {
        return this.table.newWriteSelector();
    }

    @Override
    public BatchWriteBuilder withOverwrite(@Nullable Map<String, String> staticPartition) {
        this.staticPartition = staticPartition;
        return this;
    }

    @Override
    public BatchTableWrite newWrite() {
        return this.table.newWrite(this.commitUser).withIgnorePreviousFiles(this.staticPartition != null).withExecutionMode(false);
    }

    @Override
    public BatchTableCommit newCommit() {
        InnerTableCommit commit = this.table.newCommit(this.commitUser).withOverwrite(this.staticPartition);
        commit.ignoreEmptyCommit(true);
        return commit;
    }
}

