/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.algorithm.generator;

import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.tinkerpop.gremlin.algorithm.generator.Generator;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;

public abstract class AbstractGenerator
implements Generator {
    protected final Graph g;
    private final String label;
    private final Optional<Consumer<Edge>> edgeProcessor;
    private final Optional<BiConsumer<Vertex, Map<String, Object>>> vertexProcessor;
    protected final Supplier<Long> seedSupplier;

    AbstractGenerator(Graph g, String label, Optional<Consumer<Edge>> edgeProcessor, Optional<BiConsumer<Vertex, Map<String, Object>>> vertexProcessor, Supplier<Long> seedGenerator) {
        this.g = g;
        this.label = label;
        this.edgeProcessor = edgeProcessor;
        this.vertexProcessor = vertexProcessor;
        this.seedSupplier = seedGenerator;
    }

    protected final Edge addEdge(Vertex out, Vertex in) {
        Edge e = out.addEdge(this.label, in, new Object[0]);
        this.edgeProcessor.ifPresent(c -> c.accept(e));
        return e;
    }

    protected final Vertex processVertex(Vertex vertex, Map<String, Object> context) {
        this.vertexProcessor.ifPresent(c -> c.accept(vertex, context));
        return vertex;
    }

    public static abstract class AbstractGeneratorBuilder<T extends AbstractGeneratorBuilder> {
        protected String label;
        protected Optional<Consumer<Edge>> edgeProcessor = Optional.empty();
        protected Optional<BiConsumer<Vertex, Map<String, Object>>> vertexProcessor = Optional.empty();
        protected Supplier<Long> seedSupplier = System::currentTimeMillis;
        private final Class<T> extendingClass;

        AbstractGeneratorBuilder(Class<T> extendingClass) {
            this.extendingClass = extendingClass;
        }

        public T label(String label) {
            if (null == label || label.isEmpty()) {
                throw new IllegalArgumentException("Label cannot be empty");
            }
            this.label = label;
            return (T)((AbstractGeneratorBuilder)this.extendingClass.cast(this));
        }

        public T edgeProcessor(Consumer<Edge> edgeProcessor) {
            this.edgeProcessor = Optional.ofNullable(edgeProcessor);
            return (T)((AbstractGeneratorBuilder)this.extendingClass.cast(this));
        }

        public T vertexProcessor(BiConsumer<Vertex, Map<String, Object>> vertexProcessor) {
            this.vertexProcessor = Optional.ofNullable(vertexProcessor);
            return (T)((AbstractGeneratorBuilder)this.extendingClass.cast(this));
        }

        public T seedGenerator(Supplier<Long> seedGenerator) {
            this.seedSupplier = Optional.ofNullable(seedGenerator).orElse(System::currentTimeMillis);
            return (T)((AbstractGeneratorBuilder)this.extendingClass.cast(this));
        }
    }
}

