/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.script.Bindings;
import org.apache.tinkerpop.gremlin.jsr223.GremlinScriptEngine;
import org.apache.tinkerpop.gremlin.jsr223.SingleGremlinScriptEngineManager;
import org.apache.tinkerpop.gremlin.process.computer.traversal.strategy.decoration.VertexProgramStrategy;
import org.apache.tinkerpop.gremlin.process.remote.traversal.strategy.decoration.RemoteStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.Bytecode;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Translator;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.EmptyStep;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.AbstractTraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration.ConnectiveStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration.ElementIdStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration.EventStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration.HaltedTraverserStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration.PartitionStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration.RequirementsStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration.SackStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration.SeedStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration.SideEffectStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration.SubgraphStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalHelper;
import org.junit.Assert;

public final class TranslationStrategy
extends AbstractTraversalStrategy<TraversalStrategy.DecorationStrategy>
implements TraversalStrategy.DecorationStrategy {
    private final TraversalSource traversalSource;
    private final Translator translator;
    private final boolean assertBytecode;
    private static final Set<Class<? extends TraversalStrategy.DecorationStrategy>> POSTS = new HashSet<Class>(Arrays.asList(ConnectiveStrategy.class, ElementIdStrategy.class, EventStrategy.class, HaltedTraverserStrategy.class, PartitionStrategy.class, RequirementsStrategy.class, SackStrategy.class, SeedStrategy.class, SideEffectStrategy.class, SubgraphStrategy.class, RemoteStrategy.class, VertexProgramStrategy.class));

    public TranslationStrategy(TraversalSource traversalSource, Translator translator, boolean assertBytecode) {
        this.traversalSource = traversalSource;
        this.translator = translator;
        this.assertBytecode = assertBytecode;
    }

    public void apply(Traversal.Admin<?, ?> traversal) {
        Traversal.Admin translatedTraversal;
        if (!traversal.isRoot() || traversal.getBytecode().isEmpty()) {
            return;
        }
        Bytecode bytecode = TranslationStrategy.removeTranslationStrategy(TranslationStrategy.insertBindingsForTesting(traversal.getBytecode()));
        if (this.translator instanceof Translator.StepTranslator) {
            translatedTraversal = (Traversal.Admin)this.translator.translate(bytecode);
        } else if (this.translator instanceof Translator.ScriptTranslator) {
            try {
                GremlinScriptEngine scriptEngine = SingleGremlinScriptEngineManager.get((String)this.translator.getTargetLanguage());
                Bindings bindings = scriptEngine.createBindings();
                bindings.putAll(scriptEngine.getContext().getBindings(100));
                bindings.put(this.translator.getTraversalSource().toString(), (Object)this.traversalSource);
                translatedTraversal = scriptEngine.eval(bytecode, bindings, this.translator.getTraversalSource().toString());
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e.getMessage(), e);
            }
        } else {
            throw new IllegalArgumentException("TranslationStrategy does not know how to process the provided translator type: " + this.translator.getClass().getSimpleName());
        }
        assert (!translatedTraversal.isLocked());
        assert (!traversal.isLocked());
        traversal.setSideEffects(translatedTraversal.getSideEffects());
        TraversalHelper.removeAllSteps(traversal);
        TraversalHelper.removeToTraversal((Step)translatedTraversal.getStartStep(), (Step)EmptyStep.instance(), traversal);
        if (this.assertBytecode) {
            Assert.assertEquals((Object)TranslationStrategy.removeTranslationStrategy(traversal.getBytecode()), (Object)translatedTraversal.getBytecode());
        }
    }

    public Set<Class<? extends TraversalStrategy.DecorationStrategy>> applyPost() {
        return POSTS;
    }

    private static final Bytecode removeTranslationStrategy(Bytecode bytecode) {
        if (bytecode.getSourceInstructions().size() > 0) {
            bytecode.getSourceInstructions().remove(0);
        }
        return bytecode;
    }

    private static final Bytecode insertBindingsForTesting(Bytecode bytecode) {
        Bytecode newBytecode = new Bytecode();
        for (Bytecode.Instruction instruction : bytecode.getSourceInstructions()) {
            newBytecode.addSource(instruction.getOperator(), instruction.getArguments());
        }
        for (Bytecode.Instruction instruction : bytecode.getStepInstructions()) {
            Object[] args = instruction.getArguments();
            Object[] newArgs = new Object[args.length];
            for (int i = 0; i < args.length; ++i) {
                newArgs[i] = args[i] == null ? null : (args[i].equals("knows") ? new Bytecode.Binding("a", (Object)"knows") : (args[i].equals("created") ? new Bytecode.Binding("b", (Object)"created") : (args[i].equals(10) ? new Bytecode.Binding("c", (Object)10) : args[i])));
            }
            newBytecode.addStep(instruction.getOperator(), newArgs);
        }
        return newBytecode;
    }
}

