/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.backend.store.raft.compress;

import org.apache.hugegraph.backend.store.raft.compress.CompressStrategy;
import org.apache.hugegraph.backend.store.raft.compress.ParallelCompressStrategy;
import org.apache.hugegraph.backend.store.raft.compress.SerialCompressStrategy;
import org.apache.hugegraph.config.CoreOptions;
import org.apache.hugegraph.config.HugeConfig;

public class CompressStrategyManager {
    private static byte DEFAULT_STRATEGY = 1;
    public static final byte SERIAL_STRATEGY = 1;
    public static final byte PARALLEL_STRATEGY = 2;
    public static final byte MAX_STRATEGY = 5;
    private static CompressStrategy[] compressStrategies = new CompressStrategy[5];

    private CompressStrategyManager() {
    }

    public static void addCompressStrategy(int index, CompressStrategy compressStrategy) {
        if (compressStrategies.length <= index) {
            CompressStrategy[] newCompressStrategies = new CompressStrategy[index + 5];
            System.arraycopy(compressStrategies, 0, newCompressStrategies, 0, compressStrategies.length);
            compressStrategies = newCompressStrategies;
        }
        CompressStrategyManager.compressStrategies[index] = compressStrategy;
    }

    public static CompressStrategy getDefault() {
        return compressStrategies[DEFAULT_STRATEGY];
    }

    public static void init(HugeConfig config) {
        if (!((Boolean)config.get(CoreOptions.RAFT_SNAPSHOT_PARALLEL_COMPRESS)).booleanValue()) {
            return;
        }
        if (compressStrategies[2] == null) {
            ParallelCompressStrategy compressStrategy = new ParallelCompressStrategy((Integer)config.get(CoreOptions.RAFT_SNAPSHOT_COMPRESS_THREADS), (Integer)config.get(CoreOptions.RAFT_SNAPSHOT_DECOMPRESS_THREADS));
            CompressStrategyManager.addCompressStrategy(2, compressStrategy);
            DEFAULT_STRATEGY = (byte)2;
        }
    }

    static {
        CompressStrategyManager.addCompressStrategy(1, new SerialCompressStrategy());
    }
}

