/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.access;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.security.access.TablePermission;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class UserPermission
extends TablePermission {
    private static final Logger LOG = LoggerFactory.getLogger(UserPermission.class);
    private byte[] user;

    public UserPermission() {
    }

    public UserPermission(byte[] user, Permission.Action ... assigned) {
        super((TableName)null, (byte[])null, (byte[])null, assigned);
        this.user = user;
    }

    public UserPermission(byte[] user, byte[] actionCodes) {
        super(null, null, null, actionCodes);
        this.user = user;
    }

    public UserPermission(byte[] user, String namespace, Permission.Action ... assigned) {
        super(namespace, assigned);
        this.user = user;
    }

    public UserPermission(byte[] user, String namespace, byte[] actionCodes) {
        super(namespace, actionCodes);
        this.user = user;
    }

    public UserPermission(byte[] user, TableName table, byte[] family, Permission.Action ... assigned) {
        super(table, family, assigned);
        this.user = user;
    }

    public UserPermission(byte[] user, TableName table, byte[] family, byte[] qualifier, Permission.Action ... assigned) {
        super(table, family, qualifier, assigned);
        this.user = user;
    }

    public UserPermission(byte[] user, TableName table, byte[] family, byte[] qualifier, byte[] actionCodes) {
        super(table, family, qualifier, actionCodes);
        this.user = user;
    }

    public UserPermission(byte[] user, TablePermission perm) {
        super(perm.getNamespace(), perm.getTableName(), perm.getFamily(), perm.getQualifier(), perm.actions);
        this.user = user;
    }

    public byte[] getUser() {
        return this.user;
    }

    public boolean isGlobal() {
        return !this.hasTable() && !this.hasNamespace();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof UserPermission)) {
            return false;
        }
        UserPermission other = (UserPermission)obj;
        return Bytes.equals(this.user, other.getUser()) && super.equals(obj);
    }

    @Override
    public int hashCode() {
        int prime = 37;
        int result = super.hashCode();
        if (this.user != null) {
            result = 37 * result + Bytes.hashCode(this.user);
        }
        return result;
    }

    @Override
    public String toString() {
        StringBuilder str = new StringBuilder("UserPermission: ").append("user=").append(Bytes.toString(this.user)).append(", ").append(super.toString());
        return str.toString();
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.user = Bytes.readByteArray(in);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        Bytes.writeByteArray(out, this.user);
    }
}

