/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.jets3t.service.model;

import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.hadoop.hbase.shaded.com.jamesmurty.utils.XMLBuilder;
import org.apache.hadoop.hbase.shaded.org.jets3t.service.ServiceException;

public abstract class StorageBucketLoggingStatus {
    private String targetBucketName = null;
    private String logfilePrefix = null;

    public StorageBucketLoggingStatus() {
    }

    public StorageBucketLoggingStatus(String targetBucketName, String logfilePrefix) {
        this.targetBucketName = targetBucketName;
        this.logfilePrefix = logfilePrefix;
    }

    public boolean isLoggingEnabled() {
        return this.targetBucketName != null && this.logfilePrefix != null;
    }

    public String getLogfilePrefix() {
        return this.logfilePrefix;
    }

    public void setLogfilePrefix(String logfilePrefix) {
        this.logfilePrefix = logfilePrefix;
    }

    public String getTargetBucketName() {
        return this.targetBucketName;
    }

    public void setTargetBucketName(String targetBucketName) {
        this.targetBucketName = targetBucketName;
    }

    public String toString() {
        String result = "LoggingStatus enabled=" + this.isLoggingEnabled();
        if (this.isLoggingEnabled()) {
            result = result + ", targetBucketName=" + this.getTargetBucketName() + ", logfilePrefix=" + this.getLogfilePrefix();
        }
        return result;
    }

    public String toXml() throws ServiceException {
        try {
            return this.toXMLBuilder().asString();
        }
        catch (Exception e) {
            throw new ServiceException("Failed to build XML document for ACL", e);
        }
    }

    public abstract XMLBuilder toXMLBuilder() throws ParserConfigurationException, FactoryConfigurationError, TransformerException;
}

