/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.analyzer;

import com.google.common.collect.ImmutableList;
import java.io.StringReader;
import java.util.List;
import java.util.Set;
import org.apache.hugegraph.analyzer.Analyzer;
import org.apache.hugegraph.config.ConfigException;
import org.apache.hugegraph.exception.HugeException;
import org.apache.hugegraph.util.InsertionOrderUtil;
import org.lionsoul.jcseg.tokenizer.core.ADictionary;
import org.lionsoul.jcseg.tokenizer.core.DictionaryFactory;
import org.lionsoul.jcseg.tokenizer.core.ISegment;
import org.lionsoul.jcseg.tokenizer.core.IWord;
import org.lionsoul.jcseg.tokenizer.core.JcsegTaskConfig;
import org.lionsoul.jcseg.tokenizer.core.SegmentFactory;

public class JcsegAnalyzer
implements Analyzer {
    public static final List<String> SUPPORT_MODES = ImmutableList.of((Object)"Simple", (Object)"Complex");
    private static final JcsegTaskConfig CONFIG = new JcsegTaskConfig();
    private static final ADictionary DIC = DictionaryFactory.createDefaultDictionary((JcsegTaskConfig)new JcsegTaskConfig());
    private int segMode;

    public JcsegAnalyzer(String mode) {
        if (!SUPPORT_MODES.contains(mode)) {
            throw new ConfigException("Unsupported segment mode '%s' for jcseg analyzer, the available values are %s", new Object[]{mode, SUPPORT_MODES});
        }
        this.segMode = SUPPORT_MODES.indexOf(mode) + 1;
    }

    @Override
    public Set<String> segment(String text) {
        Set result = InsertionOrderUtil.newSet();
        try {
            Object[] args = new Object[]{new StringReader(text), CONFIG, DIC};
            ISegment seg = SegmentFactory.createJcseg((int)this.segMode, (Object[])args);
            IWord word = null;
            while ((word = seg.next()) != null) {
                result.add(word.getValue());
            }
        }
        catch (Exception e) {
            throw new HugeException("Jcseg segment text '%s' failed", (Throwable)e, text);
        }
        return result;
    }
}

