/*
 * Decompiled with CFR 0.152.
 */
package org.apache.livy.repl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.InetAddress;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import org.apache.livy.Logging;
import org.apache.livy.Utils$;
import org.apache.livy.client.common.ClientConf;
import org.apache.livy.repl.Interpreter;
import org.apache.livy.repl.PySparkJobProcessor;
import org.apache.livy.repl.PythonInterpreter;
import org.apache.livy.rsc.driver.SparkEntries;
import org.apache.spark.SparkConf;
import org.slf4j.Logger;
import py4j.Gateway;
import py4j.GatewayServer;
import py4j.Py4JException;
import py4j.reflection.PythonProxyHandler;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;
import scala.util.control.NonFatal$;

public final class PythonInterpreter$
implements Logging {
    public static PythonInterpreter$ MODULE$;
    private Logger logger;
    private volatile boolean bitmap$0;

    static {
        new PythonInterpreter$();
    }

    public void trace(Function0<Object> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<Object> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<Object> message) {
        Logging.info$((Logging)this, message);
    }

    public void warn(Function0<Object> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        PythonInterpreter$ pythonInterpreter$ = this;
        synchronized (pythonInterpreter$) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public Interpreter apply(SparkConf conf, SparkEntries sparkEntries) {
        String pythonExec = (String)conf.getOption("spark.pyspark.python").orElse((Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.env().get((Object)"PYSPARK_PYTHON")).orElse((Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.props().get("pyspark.python")).getOrElse((Function0 & Serializable & scala.Serializable)() -> "python");
        String secretKey = Utils$.MODULE$.createSecret(256);
        GatewayServer gatewayServer = this.createGatewayServer(sparkEntries, secretKey);
        gatewayServer.start();
        ProcessBuilder builder = new ProcessBuilder((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)pythonExec, (List)new .colon.colon((Object)this.createFakeShell().toString(), (List)Nil$.MODULE$))).asJava());
        Map<String, String> env = builder.environment();
        String[] pythonPath = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((String)package$.MODULE$.env().getOrElse((Object)"PYTHONPATH", (Function0 & Serializable & scala.Serializable)() -> "")).split(File.pathSeparator))).$plus$plus(!ClientConf.TEST_MODE ? this.findPySparkArchives() : Nil$.MODULE$, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).$plus$plus(!ClientConf.TEST_MODE ? this.findPyFiles(conf) : Nil$.MODULE$, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        env.put("PYSPARK_PYTHON", pythonExec);
        env.put("PYTHONPATH", new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pythonPath)).mkString(File.pathSeparator));
        env.put("PYTHONUNBUFFERED", "YES");
        env.put("PYSPARK_GATEWAY_PORT", String.valueOf(BoxesRunTime.boxToInteger((int)gatewayServer.getListeningPort())));
        env.put("PYSPARK_GATEWAY_SECRET", secretKey);
        env.put("SPARK_HOME", (String)package$.MODULE$.env().getOrElse((Object)"SPARK_HOME", (Function0 & Serializable & scala.Serializable)() -> "."));
        env.put("LIVY_SPARK_MAJOR_VERSION", conf.get("spark.livy.spark_major_version", "1"));
        builder.redirectError(ProcessBuilder.Redirect.PIPE);
        Process process = builder.start();
        return new PythonInterpreter(process, gatewayServer);
    }

    private Seq<String> findPySparkArchives() {
        return (Seq)package$.MODULE$.env().get((Object)"PYSPARK_ARCHIVES_PATH").map((Function1 & Serializable & scala.Serializable)x$1 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$1.split(","))).toSeq()).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)package$.MODULE$.env().get((Object)"SPARK_HOME").map((Function1 & Serializable & scala.Serializable)sparkHome -> {
            String pyLibPath = ((TraversableOnce)new .colon.colon(sparkHome, (List)new .colon.colon((Object)"python", (List)new .colon.colon((Object)"lib", (List)Nil$.MODULE$)))).mkString(File.separator);
            File pyArchivesFile = new File(pyLibPath, "pyspark.zip");
            Predef$.MODULE$.require(pyArchivesFile.exists(), (Function0 & Serializable & scala.Serializable)() -> "pyspark.zip not found; cannot start pyspark interpreter.");
            File py4jFile = Files.newDirectoryStream(Paths.get(pyLibPath, new String[0]), "py4j-*-src.zip").iterator().next().toFile();
            Predef$.MODULE$.require(py4jFile.exists(), (Function0 & Serializable & scala.Serializable)() -> "py4j-*-src.zip not found; cannot start pyspark interpreter.");
            return (Seq)new .colon.colon((Object)pyArchivesFile.getAbsolutePath(), (List)new .colon.colon((Object)py4jFile.getAbsolutePath(), (List)Nil$.MODULE$));
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Nil$.MODULE$));
    }

    private Seq<String> findPyFiles(SparkConf conf) {
        String[] pyFiles;
        block3: {
            block2: {
                pyFiles = ((String)package$.MODULE$.props().getOrElse((Object)"spark.submit.pyFiles", (Function0 & Serializable & scala.Serializable)() -> "")).split(",");
                Object object = package$.MODULE$.env().getOrElse((Object)"SPARK_YARN_MODE", (Function0 & Serializable & scala.Serializable)() -> "");
                String string = "true";
                if (!(object == null ? string != null : !object.equals(string))) break block2;
                String string2 = conf.get("spark.master", "").toLowerCase();
                String string3 = "yarn";
                if (string2 != null ? !string2.equals(string3) : string3 != null) break block3;
                String string4 = conf.get("spark.submit.deployMode", "").toLowerCase();
                String string5 = "cluster";
                if (string4 != null ? !string4.equals(string5) : string5 != null) break block3;
            }
            return (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pyFiles)).map((Function1 & Serializable & scala.Serializable)file -> {
                String name = new File((String)file).getName();
                return new File(name).getAbsolutePath();
            }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
        }
        return Predef$.MODULE$.wrapRefArray((Object[])pyFiles);
    }

    private File createFakeShell() {
        InputStream source = this.getClass().getClassLoader().getResourceAsStream("fake_shell.py");
        File file = Files.createTempFile("", "", new FileAttribute[0]).toFile();
        file.deleteOnExit();
        FileOutputStream sink = new FileOutputStream(file);
        byte[] buf = new byte[1024];
        int n = source.read(buf);
        while (n > 0) {
            sink.write(buf, 0, n);
            n = source.read(buf);
        }
        source.close();
        sink.close();
        return file;
    }

    private GatewayServer createGatewayServer(SparkEntries sparkEntries, String secretKey) {
        GatewayServer gatewayServer;
        try {
            Class<?> clz = Class.forName("py4j.GatewayServer$GatewayServerBuilder", true, Thread.currentThread().getContextClassLoader());
            Object builder = clz.getConstructor(Object.class).newInstance(sparkEntries);
            InetAddress localhost = InetAddress.getLoopbackAddress();
            builder.getClass().getMethod("authToken", String.class).invoke(builder, secretKey);
            builder.getClass().getMethod("javaPort", Integer.TYPE).invoke(builder, Predef$.MODULE$.int2Integer(0));
            builder.getClass().getMethod("javaAddress", InetAddress.class).invoke(builder, localhost);
            builder.getClass().getMethod("callbackClient", Integer.TYPE, InetAddress.class, String.class).invoke(builder, Predef$.MODULE$.int2Integer(25334), localhost, secretKey);
            gatewayServer = (GatewayServer)builder.getClass().getMethod("build", new Class[0]).invoke(builder, new Object[0]);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "Fail to create GatewayServer with auth parameter, downgrade to old constructor", e);
                gatewayServer = new GatewayServer((Object)sparkEntries, 0);
            }
            throw throwable;
        }
        return gatewayServer;
    }

    public PySparkJobProcessor org$apache$livy$repl$PythonInterpreter$$initiatePy4jCallbackGateway(GatewayServer server) {
        Field f = server.getClass().getDeclaredField("gateway");
        f.setAccessible(true);
        Gateway gateway = (Gateway)f.get(server);
        String command = "ft;org.apache.livy.repl.PySparkJobProcessor";
        return (PySparkJobProcessor)this.getPythonProxy(command, gateway);
    }

    private Object getPythonProxy(String commandPart, Gateway gateway) {
        PythonProxyHandler pythonProxyHandler;
        String proxyString = commandPart.substring(1, commandPart.length());
        String[] parts = proxyString.split(";");
        int length = parts.length;
        ArrayBuffer interfaces = (ArrayBuffer)ArrayBuffer$.MODULE$.fill(length - 1, (Function0 & Serializable & scala.Serializable)() -> null);
        if (length < 2) {
            throw new Py4JException("Invalid Python Proxy.");
        }
        for (int proxy = 1; proxy < length; ++proxy) {
            try {
                interfaces.update(proxy - 1, Class.forName(parts[proxy]));
                if (((Class)interfaces.apply(proxy - 1)).isInterface()) continue;
                throw new Py4JException(new StringBuilder(69).append("This class ").append(parts[proxy]).append(" is not an interface and cannot be used as a Python Proxy.").toString());
            }
            catch (ClassNotFoundException exception) {
                throw new Py4JException(new StringBuilder(24).append("Invalid interface name: ").append(parts[proxy]).toString());
            }
        }
        try {
            pythonProxyHandler = (PythonProxyHandler)PythonProxyHandler.class.getConstructor(String.class, Gateway.class).newInstance(parts[0], gateway);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Object cbClient = gateway.getClass().getMethod("getCallbackClient", new Class[0]).invoke((Object)gateway, new Object[0]);
                Class<?> cbClass = Class.forName("py4j.CallbackClient");
                pythonProxyHandler = (PythonProxyHandler)PythonProxyHandler.class.getConstructor(String.class, cbClass, Gateway.class).newInstance(parts[0], cbClient, gateway);
            }
            throw throwable;
        }
        PythonProxyHandler pythonProxyHandler2 = pythonProxyHandler;
        return Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), (Class[])interfaces.toArray(ClassTag$.MODULE$.apply(Class.class)), (InvocationHandler)pythonProxyHandler2);
    }

    private PythonInterpreter$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

