/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.polaris.core.entity;

/**
 * An interface for entity types that have an id. These entities provide a * method `getId` and
 * `getCatalogId` to identify the entity.
 */
public interface Identifiable {
  /**
   * @return the id of the catalog associated to that entity. NULL_ID if this entity is top-level
   *     like a catalog
   */
  long getCatalogId();

  /**
   * @return the id of the entity
   */
  long getId();
}
