/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd.options;

import io.etcd.jetcd.ByteSequence;
import io.etcd.jetcd.api.RangeRequest;
import io.etcd.jetcd.options.GetOption;
import java.util.Arrays;

public class OptionsUtil {
    private static final byte[] NO_PREFIX_END = new byte[]{0};

    private OptionsUtil() {
    }

    static final ByteSequence prefixEndOf(ByteSequence prefix) {
        byte[] endKey = (byte[])prefix.getBytes().clone();
        for (int i = endKey.length - 1; i >= 0; --i) {
            if (endKey[i] == -1) continue;
            endKey[i] = (byte)(endKey[i] + 1);
            return ByteSequence.from(Arrays.copyOf(endKey, i + 1));
        }
        return ByteSequence.from(NO_PREFIX_END);
    }

    public static RangeRequest.SortOrder toRangeRequestSortOrder(GetOption.SortOrder order) {
        switch (order) {
            case NONE: {
                return RangeRequest.SortOrder.NONE;
            }
            case ASCEND: {
                return RangeRequest.SortOrder.ASCEND;
            }
            case DESCEND: {
                return RangeRequest.SortOrder.DESCEND;
            }
        }
        return RangeRequest.SortOrder.UNRECOGNIZED;
    }

    public static RangeRequest.SortTarget toRangeRequestSortTarget(GetOption.SortTarget target) {
        switch (target) {
            case KEY: {
                return RangeRequest.SortTarget.KEY;
            }
            case CREATE: {
                return RangeRequest.SortTarget.CREATE;
            }
            case MOD: {
                return RangeRequest.SortTarget.MOD;
            }
            case VALUE: {
                return RangeRequest.SortTarget.VALUE;
            }
            case VERSION: {
                return RangeRequest.SortTarget.VERSION;
            }
        }
        return RangeRequest.SortTarget.UNRECOGNIZED;
    }
}

