/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.http;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.security.config.http.RequestMatcherFactoryBean;
import org.springframework.security.web.RequestMatcherRedirectFilter;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public final class WellKnownChangePasswordBeanDefinitionParser
implements BeanDefinitionParser {
    private static final String WELL_KNOWN_CHANGE_PASSWORD_PATTERN = "/.well-known/change-password";
    private static final String DEFAULT_CHANGE_PASSWORD_PAGE = "/change-password";
    private static final String ATT_CHANGE_PASSWORD_PAGE = "change-password-page";

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        AbstractBeanDefinition requestMatcher = BeanDefinitionBuilder.rootBeanDefinition(RequestMatcherFactoryBean.class).addConstructorArgValue((Object)WELL_KNOWN_CHANGE_PASSWORD_PATTERN).getBeanDefinition();
        AbstractBeanDefinition changePasswordFilter = BeanDefinitionBuilder.rootBeanDefinition(RequestMatcherRedirectFilter.class).addConstructorArgValue((Object)requestMatcher).addConstructorArgValue((Object)this.getChangePasswordPage(element)).getBeanDefinition();
        parserContext.getReaderContext().registerWithGeneratedName((BeanDefinition)changePasswordFilter);
        return changePasswordFilter;
    }

    private String getChangePasswordPage(Element element) {
        String changePasswordPage = element.getAttribute(ATT_CHANGE_PASSWORD_PAGE);
        return StringUtils.hasText((String)changePasswordPage) ? changePasswordPage : DEFAULT_CHANGE_PASSWORD_PAGE;
    }
}

