/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.server.cluster.raft.execute.global;

import org.apache.seata.core.model.GlobalStatus;
import org.apache.seata.core.model.LockStatus;
import org.apache.seata.server.cluster.raft.execute.AbstractRaftMsgExecute;
import org.apache.seata.server.cluster.raft.sync.msg.RaftBaseMsg;
import org.apache.seata.server.cluster.raft.sync.msg.RaftGlobalSessionSyncMsg;
import org.apache.seata.server.cluster.raft.sync.msg.dto.GlobalTransactionDTO;
import org.apache.seata.server.session.GlobalSession;
import org.apache.seata.server.session.SessionHolder;
import org.apache.seata.server.storage.raft.session.RaftSessionManager;

public class UpdateGlobalSessionExecute
extends AbstractRaftMsgExecute {
    public Boolean execute(RaftBaseMsg syncMsg) throws Throwable {
        GlobalTransactionDTO globalTransactionDTO;
        RaftGlobalSessionSyncMsg sessionSyncMsg = (RaftGlobalSessionSyncMsg)syncMsg;
        RaftSessionManager raftSessionManager = (RaftSessionManager)SessionHolder.getRootSessionManager((String)sessionSyncMsg.getGroup());
        GlobalSession globalSession = raftSessionManager.findGlobalSession((globalTransactionDTO = sessionSyncMsg.getGlobalSession()).getXid());
        if (globalSession != null) {
            globalSession.setStatus(GlobalStatus.get((int)globalTransactionDTO.getStatus()));
            if (GlobalStatus.RollbackRetrying.equals((Object)globalSession.getStatus()) || GlobalStatus.Rollbacking.equals((Object)globalSession.getStatus()) || GlobalStatus.TimeoutRollbacking.equals((Object)globalSession.getStatus())) {
                globalSession.getBranchSessions().parallelStream().forEach(branchSession -> branchSession.setLockStatus(LockStatus.Rollbacking));
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("xid: {}, change status: {}", (Object)globalSession.getXid(), (Object)globalSession.getStatus());
            }
        }
        return true;
    }
}

