/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.core.rpc.netty.http;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http2.DefaultHttp2DataFrame;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.DefaultHttp2HeadersFrame;
import io.netty.handler.codec.http2.Http2DataFrame;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2HeadersFrame;
import io.netty.handler.codec.http2.Http2StreamFrame;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.apache.seata.core.exception.HttpRequestFilterException;
import org.apache.seata.core.rpc.netty.http.BaseHttpChannelHandler;
import org.apache.seata.core.rpc.netty.http.ControllerManager;
import org.apache.seata.core.rpc.netty.http.HttpInvocation;
import org.apache.seata.core.rpc.netty.http.ParameterParser;
import org.apache.seata.core.rpc.netty.http.RequestParseUtils;
import org.apache.seata.core.rpc.netty.http.SimpleHttp2Request;
import org.apache.seata.core.rpc.netty.http.filter.HttpFilterContext;
import org.apache.seata.core.rpc.netty.http.filter.HttpRequestFilterChain;
import org.apache.seata.core.rpc.netty.http.filter.HttpRequestFilterManager;
import org.apache.seata.core.rpc.netty.http.filter.HttpRequestParamWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Http2HttpHandler
extends BaseHttpChannelHandler<Http2StreamFrame> {
    private static final Logger LOGGER = LoggerFactory.getLogger(Http2HttpHandler.class);
    private Http2Headers http2Headers;
    private ByteBuf bodyBuffer;
    private boolean headersEndStream = false;

    protected void channelRead0(ChannelHandlerContext ctx, Http2StreamFrame msg) throws Exception {
        if (this.bodyBuffer == null) {
            this.bodyBuffer = ctx.alloc().buffer();
        }
        try {
            if (msg instanceof Http2HeadersFrame) {
                Http2HeadersFrame headersFrame = (Http2HeadersFrame)msg;
                this.http2Headers = headersFrame.headers();
                this.headersEndStream = headersFrame.isEndStream();
                if (this.headersEndStream) {
                    this.handleRequest(ctx);
                }
            } else if (msg instanceof Http2DataFrame) {
                Http2DataFrame dataFrame = (Http2DataFrame)msg;
                if (dataFrame.content().readableBytes() > 0x800000) {
                    LOGGER.error("Packet size {} exceeds maximum {}, closing connection from {}", new Object[]{dataFrame.content().readableBytes(), 0x800000, ctx.channel().remoteAddress()});
                    ctx.close();
                    return;
                }
                this.bodyBuffer.writeBytes(dataFrame.content());
                if (dataFrame.isEndStream()) {
                    this.handleRequest(ctx);
                }
            }
        }
        catch (Exception e) {
            if (this.bodyBuffer != null) {
                this.bodyBuffer.release();
                this.bodyBuffer = null;
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRequest(ChannelHandlerContext ctx) {
        try {
            Object[] args;
            if (this.http2Headers == null || this.http2Headers.method() == null || this.http2Headers.path() == null) {
                this.sendErrorResponse(ctx, HttpResponseStatus.BAD_REQUEST);
                return;
            }
            HttpMethod method = HttpMethod.valueOf((String)this.http2Headers.method().toString());
            String path = this.http2Headers.path().toString();
            String body = this.bodyBuffer != null ? this.bodyBuffer.toString(StandardCharsets.UTF_8) : "";
            Map<String, List<String>> headerParams = RequestParseUtils.copyHeaders(this.http2Headers);
            RequestParseUtils.QueryParseResult queryParseResult = RequestParseUtils.parseQuery(path);
            String requestPath = queryParseResult.getPath();
            Map<String, List<String>> queryParams = queryParseResult.getParameters();
            RequestParseUtils.BodyParseResult bodyParseResult = RequestParseUtils.parseBody(OBJECT_MAPPER, body, this.http2Headers);
            SimpleHttp2Request request = new SimpleHttp2Request(method, path, this.http2Headers, body, queryParams, bodyParseResult.getFormParams(), headerParams, bodyParseResult.getJsonParams(), bodyParseResult.getBodyNode());
            HttpFilterContext<SimpleHttp2Request> context = new HttpFilterContext<SimpleHttp2Request>(request, ctx, true, "HTTP/2.0", () -> new HttpRequestParamWrapper(queryParams, bodyParseResult.getFormParams(), headerParams, bodyParseResult.getJsonParams()));
            HttpInvocation httpInvocation = ControllerManager.getHttpInvocation(requestPath);
            if (httpInvocation == null) {
                this.sendErrorResponse(ctx, HttpResponseStatus.NOT_FOUND);
                return;
            }
            context.setAttribute("httpInvocation", httpInvocation);
            context.setAttribute("httpController", httpInvocation.getController());
            context.setAttribute("handleMethod", httpInvocation.getMethod());
            ObjectNode requestDataNode = OBJECT_MAPPER.createObjectNode();
            requestDataNode.set("param", (JsonNode)ParameterParser.convertParamMap(queryParams));
            if (request.getMethod() == HttpMethod.POST && request.getBodyNode() != null) {
                requestDataNode.set("body", (JsonNode)request.getBodyNode());
            }
            Method handleMethod = httpInvocation.getMethod();
            try {
                args = ParameterParser.getArgValues(httpInvocation.getParamMetaData(), handleMethod, requestDataNode, context);
            }
            catch (Exception e) {
                LOGGER.error("Error parsing request arguments for HTTP/2: {}", (Object)e.getMessage(), (Object)e);
                this.sendErrorResponse(ctx, HttpResponseStatus.BAD_REQUEST);
                if (this.bodyBuffer != null) {
                    this.bodyBuffer.release();
                    this.bodyBuffer = null;
                }
                this.http2Headers = null;
                this.headersEndStream = false;
                return;
            }
            context.setAttribute("args", args);
            HttpRequestFilterChain filterChain = HttpRequestFilterManager.getFilterChain(this::executeFinalAction);
            HTTP_HANDLER_THREADS.execute(() -> {
                try {
                    filterChain.doFilter(context);
                }
                catch (HttpRequestFilterException e) {
                    LOGGER.warn("Request blocked by filter while processing HTTP2 request: {}", (Object)e.getMessage());
                    this.sendErrorResponse(ctx, HttpResponseStatus.BAD_REQUEST);
                }
                catch (Exception e) {
                    LOGGER.error("Exception occurred while processing HTTP2 request: {}", (Object)e.getMessage(), (Object)e);
                    this.sendErrorResponse(ctx, HttpResponseStatus.INTERNAL_SERVER_ERROR);
                }
            });
        }
        catch (Exception e) {
            LOGGER.error("Exception occurred while processing HTTP2 request: {}", (Object)e.getMessage(), (Object)e);
            this.sendErrorResponse(ctx, HttpResponseStatus.INTERNAL_SERVER_ERROR);
        }
        finally {
            if (this.bodyBuffer != null) {
                this.bodyBuffer.release();
                this.bodyBuffer = null;
            }
            this.http2Headers = null;
            this.headersEndStream = false;
        }
    }

    private void executeFinalAction(HttpFilterContext<?> context) {
        HttpInvocation httpInvocation = (HttpInvocation)context.getAttribute("httpInvocation");
        Object httpController = context.getAttribute("httpController");
        Method handleMethod = (Method)context.getAttribute("handleMethod");
        Object[] args = (Object[])context.getAttribute("args");
        try {
            Object result = handleMethod.invoke(httpController, args);
            if (!context.isAsync()) {
                this.sendResponse(context.getContext(), result);
            }
        }
        catch (IllegalAccessException e) {
            LOGGER.error("Illegal argument exception: {}", (Object)e.getMessage(), (Object)e);
            this.sendErrorResponse(context.getContext(), HttpResponseStatus.BAD_REQUEST);
        }
        catch (Exception e) {
            LOGGER.error("Exception occurred while processing HTTP2 request: {}", (Object)e.getMessage(), (Object)e);
            this.sendErrorResponse(context.getContext(), HttpResponseStatus.INTERNAL_SERVER_ERROR);
        }
    }

    private void sendResponse(ChannelHandlerContext ctx, Object result) throws Exception {
        byte[] body = result != null ? OBJECT_MAPPER.writeValueAsBytes(result) : new byte[]{};
        Http2Headers headers = new DefaultHttp2Headers().status((CharSequence)HttpResponseStatus.OK.codeAsText());
        headers.set((Object)HttpHeaderNames.CONTENT_TYPE, (Object)"application/json; charset=UTF-8");
        headers.set((Object)HttpHeaderNames.CONTENT_LENGTH, (Object)String.valueOf(body.length));
        ctx.write((Object)new DefaultHttp2HeadersFrame(headers));
        if (body.length > 0) {
            ByteBuf content = Unpooled.wrappedBuffer((byte[])body);
            ctx.write((Object)new DefaultHttp2DataFrame(content, true));
        } else {
            ctx.write((Object)new DefaultHttp2DataFrame(Unpooled.EMPTY_BUFFER, true));
        }
        ctx.flush();
    }

    private void sendErrorResponse(ChannelHandlerContext ctx, HttpResponseStatus status) {
        Http2Headers headers = new DefaultHttp2Headers().status((CharSequence)status.codeAsText());
        ctx.writeAndFlush((Object)new DefaultHttp2HeadersFrame(headers, true));
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (cause instanceof IOException) {
            LOGGER.trace("Client connection closed: {}", (Object)cause.getMessage());
        } else {
            LOGGER.error("Exception caught in Http2HttpHandler: ", cause);
        }
        ctx.close();
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        try {
            if (this.bodyBuffer != null) {
                this.bodyBuffer.release();
                this.bodyBuffer = null;
            }
        }
        finally {
            super.channelInactive(ctx);
        }
    }
}

