/*
 * Decompiled with CFR 0.152.
 */
package org.springaicommunity.mcp.context;

import io.modelcontextprotocol.common.McpTransportContext;
import io.modelcontextprotocol.spec.McpSchema;
import io.modelcontextprotocol.util.Assert;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public interface McpRequestContextTypes<ET> {
    public McpSchema.Request request();

    public ET exchange();

    public String sessionId();

    public McpSchema.Implementation clientInfo();

    public McpSchema.ClientCapabilities clientCapabilities();

    public Map<String, Object> requestMeta();

    public McpTransportContext transportContext();

    public static interface LoggingSpec {
        public LoggingSpec message(String var1);

        public LoggingSpec logger(String var1);

        public LoggingSpec level(McpSchema.LoggingLevel var1);

        public LoggingSpec meta(Map<String, Object> var1);

        public LoggingSpec meta(String var1, Object var2);
    }

    public static interface ProgressSpec {
        public ProgressSpec progress(double var1);

        public ProgressSpec total(double var1);

        public ProgressSpec message(String var1);

        public ProgressSpec meta(Map<String, Object> var1);

        public ProgressSpec meta(String var1, Object var2);

        default public ProgressSpec percentage(int percentage) {
            Assert.isTrue((percentage >= 0 && percentage <= 100 ? 1 : 0) != 0, (String)"Percentage must be between 0 and 100");
            return this.progress(percentage).total(100.0);
        }
    }

    public static interface SamplingSpec {
        public SamplingSpec message(McpSchema.ResourceLink ... var1);

        public SamplingSpec message(McpSchema.EmbeddedResource ... var1);

        public SamplingSpec message(McpSchema.AudioContent ... var1);

        public SamplingSpec message(McpSchema.ImageContent ... var1);

        public SamplingSpec message(McpSchema.TextContent ... var1);

        default public SamplingSpec message(String ... text) {
            return this.message(List.of(text).stream().map(t -> new McpSchema.TextContent(t)).toList().toArray(new McpSchema.TextContent[0]));
        }

        public SamplingSpec message(McpSchema.SamplingMessage ... var1);

        public SamplingSpec modelPreferences(Consumer<ModelPreferenceSpec> var1);

        public SamplingSpec systemPrompt(String var1);

        public SamplingSpec includeContextStrategy(McpSchema.CreateMessageRequest.ContextInclusionStrategy var1);

        public SamplingSpec temperature(Double var1);

        public SamplingSpec maxTokens(Integer var1);

        public SamplingSpec stopSequences(String ... var1);

        public SamplingSpec metadata(Map<String, Object> var1);

        public SamplingSpec metadata(String var1, Object var2);

        public SamplingSpec meta(Map<String, Object> var1);

        public SamplingSpec meta(String var1, Object var2);
    }

    public static interface ModelPreferenceSpec {
        public ModelPreferenceSpec modelHints(String ... var1);

        public ModelPreferenceSpec modelHint(String var1);

        public ModelPreferenceSpec costPriority(Double var1);

        public ModelPreferenceSpec speedPriority(Double var1);

        public ModelPreferenceSpec intelligencePriority(Double var1);
    }

    public static interface ElicitationSpec {
        public ElicitationSpec message(String var1);

        public ElicitationSpec meta(Map<String, Object> var1);

        public ElicitationSpec meta(String var1, Object var2);
    }
}

