/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.mcp.tools;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import org.apache.seata.common.result.SingleResult;
import org.apache.seata.mcp.service.ConsoleApiService;
import org.springaicommunity.mcp.annotation.McpTool;
import org.springframework.stereotype.Service;

@Service
public class NameSpaceTools {
    private final ConsoleApiService mcpRPCService;
    private final ObjectMapper objectMapper;

    public NameSpaceTools(ConsoleApiService mcpRPCService, ObjectMapper objectMapper) {
        this.mcpRPCService = mcpRPCService;
        this.objectMapper = objectMapper;
    }

    @McpTool(description="Get the namespace and cluster or vgroup where all TC/Servers are located")
    public SingleResult<?> getTCNameSpaces() {
        String result = this.mcpRPCService.getCallNameSpace("/api/v1/naming/namespace");
        HashMap<String, String> nameSpacesVo = new HashMap<String, String>();
        try {
            JsonNode root = this.objectMapper.readTree(result);
            JsonNode dataNode = root.get("data");
            if (dataNode != null && !dataNode.isNull()) {
                nameSpacesVo.put("namespaces", dataNode.toString());
            }
        }
        catch (JsonProcessingException e) {
            return SingleResult.failure((String)("Get namespace failed:" + e.getMessage()));
        }
        return SingleResult.success(nameSpacesVo);
    }
}

