/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.column.binary;

import java.util.Optional;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.TableMetadataImpl;
import org.apache.iotdb.db.queryengine.transformation.dag.column.ColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.binary.BinaryColumnTransformer;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.common.conf.TSFileConfig;
import org.apache.tsfile.common.regexp.LikePattern;
import org.apache.tsfile.read.common.type.Type;

public class Like2ColumnTransformer
extends BinaryColumnTransformer {
    public Like2ColumnTransformer(Type returnType, ColumnTransformer leftTransformer, ColumnTransformer rightTransformer) {
        super(returnType, leftTransformer, rightTransformer);
    }

    @Override
    protected void checkType() {
        if (!TableMetadataImpl.isCharType(this.leftTransformer.getType())) {
            throw new UnsupportedOperationException("Unsupported Type: " + this.leftTransformer.getType().getTypeEnum());
        }
        if (!TableMetadataImpl.isCharType(this.rightTransformer.getType())) {
            throw new UnsupportedOperationException("Unsupported Type: " + this.rightTransformer.getType().getTypeEnum());
        }
    }

    @Override
    protected void doTransform(Column leftColumn, Column rightColumn, ColumnBuilder builder, int positionCount) {
        for (int i = 0; i < positionCount; ++i) {
            this.transforme(leftColumn, rightColumn, builder, i);
        }
    }

    @Override
    protected void doTransform(Column leftColumn, Column rightColumn, ColumnBuilder builder, int positionCount, boolean[] selection) {
        for (int i = 0; i < positionCount; ++i) {
            if (selection[i]) {
                this.transforme(leftColumn, rightColumn, builder, i);
                continue;
            }
            builder.appendNull();
        }
    }

    private void transforme(Column leftColumn, Column rightColumn, ColumnBuilder builder, int i) {
        if (!leftColumn.isNull(i) && !rightColumn.isNull(i)) {
            LikePattern pattern = LikePattern.compile((String)rightColumn.getBinary(i).getStringValue(TSFileConfig.STRING_CHARSET), Optional.empty(), (boolean)false);
            builder.writeBoolean(pattern.getMatcher().match(leftColumn.getBinary(i).getValues(), 0, leftColumn.getBinary(i).getLength()));
        } else {
            builder.appendNull();
        }
    }
}

