/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.expr;

import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.ExprFunctionN;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.function.FunctionEnv;

public abstract class E_OneOfBase
extends ExprFunctionN {
    protected final Expr expr;
    protected final ExprList possibleValues;

    protected E_OneOfBase(String name, Expr expr, ExprList args) {
        super(name, E_OneOfBase.fixup(expr, args));
        this.expr = expr;
        this.possibleValues = args;
    }

    protected E_OneOfBase(String name, ExprList args) {
        super(name, args);
        this.expr = args.get(0);
        this.possibleValues = args.tail(1);
    }

    private static ExprList fixup(Expr expr2, ExprList args) {
        ExprList allArgs = new ExprList(expr2);
        allArgs.addAll(args);
        return allArgs;
    }

    public Expr getLHS() {
        return this.expr;
    }

    public ExprList getRHS() {
        return this.possibleValues;
    }

    protected boolean evalOneOf(Binding binding, FunctionEnv env) {
        NodeValue nv = this.expr.eval(binding, env);
        ExprEvalException error = null;
        for (Expr inExpr : this.possibleValues) {
            try {
                NodeValue maybe = inExpr.eval(binding, env);
                if (!NodeValue.sameValueAs(nv, maybe)) continue;
                return true;
            }
            catch (ExprEvalException ex) {
                error = ex;
            }
        }
        if (error != null) {
            throw error;
        }
        return false;
    }

    protected boolean evalNotOneOf(Binding binding, FunctionEnv env) {
        return !this.evalOneOf(binding, env);
    }
}

