/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.io.geojson;

import java.util.ArrayList;
import org.locationtech.jts.algorithm.Orientation;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;

public class OrientationTransformer {
    public static Geometry transformCCW(Geometry geometry) {
        if (geometry instanceof MultiPolygon) {
            MultiPolygon multiPolygon = (MultiPolygon)geometry;
            ArrayList<Polygon> polygons = new ArrayList<Polygon>();
            for (int i = 0; i < multiPolygon.getNumGeometries(); ++i) {
                Geometry polygon = multiPolygon.getGeometryN(i);
                polygons.add((Polygon)OrientationTransformer.transformCCW(polygon));
            }
            return new GeometryFactory().createMultiPolygon(polygons.toArray(new Polygon[0]));
        }
        if (geometry instanceof Polygon) {
            return OrientationTransformer.transformCCW((Polygon)geometry);
        }
        return geometry;
    }

    public static Polygon transformCCW(Polygon polygon) {
        LinearRing exteriorRing = polygon.getExteriorRing();
        LinearRing exteriorRingEnforced = OrientationTransformer.transformCCW(exteriorRing, true);
        ArrayList<LinearRing> interiorRings = new ArrayList<LinearRing>();
        for (int i = 0; i < polygon.getNumInteriorRing(); ++i) {
            interiorRings.add(OrientationTransformer.transformCCW(polygon.getInteriorRingN(i), false));
        }
        return new GeometryFactory(polygon.getPrecisionModel(), polygon.getSRID()).createPolygon(exteriorRingEnforced, interiorRings.toArray(new LinearRing[0]));
    }

    public static LinearRing transformCCW(LinearRing ring, boolean isExteriorRing) {
        boolean isRingClockWise;
        boolean bl = isRingClockWise = !Orientation.isCCW(ring.getCoordinateSequence());
        LinearRing rightHandRuleRing = isExteriorRing ? (isRingClockWise ? ring.reverse() : (LinearRing)ring.copy()) : (isRingClockWise ? (LinearRing)ring.copy() : ring.reverse());
        return rightHandRuleRing;
    }
}

