/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.commons.lang;

import org.apache.juneau.commons.lang.Value;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.Utils;

public class BooleanValue
extends Value<Boolean> {
    public static BooleanValue create() {
        return BooleanValue.of(false);
    }

    public static BooleanValue of(Boolean value) {
        return new BooleanValue(value);
    }

    public BooleanValue(Boolean value) {
        super(value);
    }

    @Override
    public boolean is(Boolean value) {
        return Utils.eq((Boolean)this.get(), value);
    }

    public boolean isAny(Boolean ... values) {
        AssertionUtils.assertArgNotNull("values", values);
        Boolean current = (Boolean)this.get();
        for (Boolean value : values) {
            if (!Utils.eq(current, value)) continue;
            return true;
        }
        return false;
    }

    public boolean isNotTrue() {
        return !this.isTrue();
    }

    public boolean isTrue() {
        return Boolean.TRUE.equals(this.get());
    }
}

