/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.util;

import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import java.io.IOException;
import java.io.InputStream;
import org.apache.juneau.commons.utils.IoUtils;
import org.apache.juneau.rest.util.BoundedServletInputStream;

public class CachingHttpServletRequest
extends HttpServletRequestWrapper {
    private final byte[] content;

    public static CachingHttpServletRequest wrap(HttpServletRequest req) throws IOException {
        if (req instanceof CachingHttpServletRequest) {
            CachingHttpServletRequest req2 = (CachingHttpServletRequest)req;
            return req2;
        }
        return new CachingHttpServletRequest(req);
    }

    protected CachingHttpServletRequest(HttpServletRequest req) throws IOException {
        super(req);
        this.content = IoUtils.readBytes((InputStream)req.getInputStream());
    }

    public byte[] getContent() {
        return this.content;
    }

    public ServletInputStream getInputStream() {
        return new BoundedServletInputStream(this.content);
    }
}

