/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.logger;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.function.Predicate;
import java.util.logging.Level;
import org.apache.juneau.BeanBuilder;
import org.apache.juneau.Enablement;
import org.apache.juneau.commons.collections.FluentMap;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.cp.BeanStore;
import org.apache.juneau.rest.logger.CallLoggingDetail;

public class CallLoggerRule {
    private final Predicate<Integer> statusFilter;
    private final Predicate<HttpServletRequest> requestFilter;
    private final Predicate<HttpServletResponse> responseFilter;
    private final Predicate<Throwable> exceptionFilter;
    private final Level level;
    private final Enablement enabled;
    private final Predicate<HttpServletRequest> enabledTest;
    private final CallLoggingDetail requestDetail;
    private final CallLoggingDetail responseDetail;

    public static Builder create(BeanStore beanStore) {
        return new Builder(beanStore);
    }

    CallLoggerRule(Builder b) {
        this.statusFilter = b.statusFilter;
        this.exceptionFilter = b.exceptionFilter;
        this.requestFilter = b.requestFilter;
        this.responseFilter = b.responseFilter;
        this.level = b.level;
        this.enabled = b.enabled;
        this.enabledTest = b.enabledTest;
        this.requestDetail = b.requestDetail;
        this.responseDetail = b.responseDetail;
    }

    public Enablement getEnabled() {
        return this.enabled;
    }

    public Predicate<HttpServletRequest> getEnabledTest() {
        return this.enabledTest;
    }

    public Level getLevel() {
        return this.level;
    }

    public CallLoggingDetail getRequestDetail() {
        return this.requestDetail;
    }

    public CallLoggingDetail getResponseDetail() {
        return this.responseDetail;
    }

    public boolean matches(HttpServletRequest req, HttpServletResponse res) {
        if (Utils.nn(this.requestFilter) && !this.requestFilter.test(req) || Utils.nn(this.responseFilter) && !this.responseFilter.test(res)) {
            return false;
        }
        if (Utils.nn(this.statusFilter) && !this.statusFilter.test(res.getStatus())) {
            return false;
        }
        Throwable e = (Throwable)req.getAttribute("Exception");
        return !Utils.nn(e) || !Utils.nn(this.exceptionFilter) || this.exceptionFilter.test(e);
    }

    protected FluentMap<String, Object> properties() {
        return CollectionUtils.filteredBeanPropertyMap().a("codeFilter", this.statusFilter).a("enabled", (Predicate<Integer>)((Object)this.enabled)).a("enabledTest", this.enabledTest).a("exceptionFilter", this.exceptionFilter).a("level", (Predicate<Throwable>)((Object)this.level)).a("requestDetail", (Predicate<Throwable>)((Object)this.requestDetail)).a("requestFilter", this.requestFilter).a("responseDetail", (Predicate<HttpServletRequest>)((Object)this.responseDetail)).a("responseFilter", this.responseFilter);
    }

    public String toString() {
        return Utils.r(this.properties());
    }

    public static class Builder
    extends BeanBuilder<CallLoggerRule> {
        Predicate<Integer> statusFilter;
        Predicate<HttpServletRequest> requestFilter;
        Predicate<HttpServletResponse> responseFilter;
        Predicate<Throwable> exceptionFilter;
        Enablement enabled;
        Predicate<HttpServletRequest> enabledTest;
        Level level;
        CallLoggingDetail requestDetail;
        CallLoggingDetail responseDetail;
        boolean logStackTrace;

        protected Builder(BeanStore beanStore) {
            super(CallLoggerRule.class, beanStore);
        }

        public Builder disabled() {
            return this.enabled(Enablement.NEVER);
        }

        public Builder enabled(Enablement value) {
            this.enabled = value;
            return this;
        }

        public Builder enabledPredicate(Predicate<HttpServletRequest> value) {
            this.enabledTest = value;
            return this;
        }

        public Builder exceptionFilter(Predicate<Throwable> value) {
            this.exceptionFilter = value;
            return this;
        }

        public Builder impl(Object value) {
            super.impl(value);
            return this;
        }

        public Builder level(Level value) {
            this.level = value;
            return this;
        }

        public Builder logStackTrace() {
            this.logStackTrace = true;
            return this;
        }

        public Builder requestDetail(CallLoggingDetail value) {
            this.requestDetail = value;
            return this;
        }

        public Builder requestFilter(Predicate<HttpServletRequest> value) {
            this.requestFilter = value;
            return this;
        }

        public Builder responseDetail(CallLoggingDetail value) {
            this.responseDetail = value;
            return this;
        }

        public Builder responseFilter(Predicate<HttpServletResponse> value) {
            this.responseFilter = value;
            return this;
        }

        public Builder statusFilter(Predicate<Integer> value) {
            this.statusFilter = value;
            return this;
        }

        public Builder type(Class<?> value) {
            super.type(value);
            return this;
        }

        @Override
        protected CallLoggerRule buildDefault() {
            return new CallLoggerRule(this);
        }
    }
}

