/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.proxy.impl;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import org.apache.aries.proxy.InvocationListener;
import org.apache.aries.proxy.impl.AbstractProxyManager;
import org.apache.aries.proxy.impl.DefaultWrapper;

public final class ProxyHandler
implements InvocationHandler {
    private final Callable<Object> target;
    private final InvocationHandler core;
    private final AbstractProxyManager proxyManager;

    public ProxyHandler(AbstractProxyManager abstractProxyManager, Callable<Object> dispatcher, InvocationListener listener) {
        this.target = dispatcher;
        this.proxyManager = abstractProxyManager;
        final InvocationListener nonNullListener = listener == null ? new DefaultWrapper() : listener;
        this.core = new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                Object result = null;
                Object token = null;
                boolean inInvoke = false;
                try {
                    token = nonNullListener.preInvoke(proxy, method, args);
                    inInvoke = true;
                    result = nonNullListener.aroundInvoke(token, proxy, ProxyHandler.this.target, method, args);
                    inInvoke = false;
                    nonNullListener.postInvoke(token, proxy, method, result);
                }
                catch (Throwable e) {
                    Throwable exceptionToRethrow;
                    block9: {
                        exceptionToRethrow = null;
                        if (!inInvoke) {
                            exceptionToRethrow = e;
                        } else {
                            if (e instanceof InvocationTargetException) {
                                e = ((InvocationTargetException)e).getTargetException();
                            }
                            if (!(e instanceof RuntimeException)) {
                                exceptionToRethrow = e;
                            }
                        }
                        try {
                            nonNullListener.postInvokeExceptionalReturn(token, proxy, method, e);
                        }
                        catch (Exception f) {
                            if (exceptionToRethrow != null) break block9;
                            exceptionToRethrow = f;
                        }
                    }
                    if (exceptionToRethrow == null) {
                        exceptionToRethrow = e;
                    }
                    throw exceptionToRethrow;
                }
                return result;
            }
        };
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getName().equals("equals") && method.getParameterTypes().length == 1 && method.getParameterTypes()[0] == Object.class) {
            Object targetObject = args[0];
            if (this.proxyManager.isProxy(targetObject)) {
                args[0] = this.proxyManager.unwrap(targetObject).call();
            }
        } else if (method.getName().equals("finalize") && method.getParameterTypes().length == 0) {
            return null;
        }
        return this.core.invoke(proxy, method, args);
    }

    public Callable<Object> getTarget() {
        return this.target;
    }
}

