/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.caffeine.lrucache;

import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.apache.camel.component.caffeine.lrucache.CaffeineLRUCache;
import org.apache.camel.component.caffeine.lrucache.CaffeineLRUSoftCache;
import org.apache.camel.component.caffeine.lrucache.CaffeineLRUWeakCache;
import org.apache.camel.spi.annotations.JdkService;
import org.apache.camel.support.LRUCacheFactory;
import org.apache.camel.util.StopWatch;
import org.apache.camel.util.concurrent.ThreadHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JdkService(value="lru-cache-factory")
public final class CaffeineLRUCacheFactory
extends LRUCacheFactory {
    private static final Logger LOG = LoggerFactory.getLogger(CaffeineLRUCacheFactory.class);
    private static final AtomicBoolean INIT = new AtomicBoolean();

    public static void warmUp() {
        if (INIT.compareAndSet(false, true)) {
            Runnable task = () -> {
                StopWatch watch = new StopWatch();
                LOG.debug("Warming up LRUCache ...");
                new CaffeineLRUCache(16);
                LOG.debug("Warming up LRUCache complete in {} millis", (Object)watch.taken());
            };
            String threadName = ThreadHelper.resolveThreadName(null, (String)"LRUCacheFactory");
            Thread thread = new Thread(task, threadName);
            thread.start();
        }
    }

    public <K, V> Map<K, V> createLRUCache(int maximumCacheSize) {
        LOG.trace("Creating LRUCache with maximumCacheSize: {}", (Object)maximumCacheSize);
        return new CaffeineLRUCache(maximumCacheSize);
    }

    public <K, V> Map<K, V> createLRUCache(int maximumCacheSize, Consumer<V> onEvict) {
        LOG.trace("Creating LRUCache with maximumCacheSize: {}", (Object)maximumCacheSize);
        return new CaffeineLRUCache(16, maximumCacheSize, onEvict, false, false, false);
    }

    public <K, V> Map<K, V> createLRUCache(int initialCapacity, int maximumCacheSize) {
        LOG.trace("Creating LRUCache with initialCapacity: {}, maximumCacheSize: {}", (Object)initialCapacity, (Object)maximumCacheSize);
        return new CaffeineLRUCache(initialCapacity, maximumCacheSize);
    }

    public <K, V> Map<K, V> createLRUCache(int initialCapacity, int maximumCacheSize, boolean stopOnEviction) {
        LOG.trace("Creating LRUCache with initialCapacity: {}, maximumCacheSize: {}, stopOnEviction: {}", new Object[]{initialCapacity, maximumCacheSize, stopOnEviction});
        return new CaffeineLRUCache(initialCapacity, maximumCacheSize, stopOnEviction);
    }

    public <K, V> Map<K, V> createLRUSoftCache(int maximumCacheSize) {
        LOG.trace("Creating LRUSoftCache with maximumCacheSize: {}", (Object)maximumCacheSize);
        return new CaffeineLRUSoftCache(maximumCacheSize);
    }

    public <K, V> Map<K, V> createLRUSoftCache(int initialCapacity, int maximumCacheSize) {
        LOG.trace("Creating LRUSoftCache with initialCapacity: {}, maximumCacheSize: {}", (Object)initialCapacity, (Object)maximumCacheSize);
        return new CaffeineLRUSoftCache(initialCapacity, maximumCacheSize);
    }

    public <K, V> Map<K, V> createLRUSoftCache(int initialCapacity, int maximumCacheSize, boolean stopOnEviction) {
        LOG.trace("Creating LRUSoftCache with initialCapacity: {}, maximumCacheSize: {}, stopOnEviction: {}", new Object[]{initialCapacity, maximumCacheSize, stopOnEviction});
        return new CaffeineLRUSoftCache(initialCapacity, maximumCacheSize, stopOnEviction);
    }

    public <K, V> Map<K, V> createLRUWeakCache(int maximumCacheSize) {
        LOG.trace("Creating LRUWeakCache with maximumCacheSize: {}", (Object)maximumCacheSize);
        return new CaffeineLRUWeakCache(maximumCacheSize);
    }

    public <K, V> Map<K, V> createLRUWeakCache(int initialCapacity, int maximumCacheSize) {
        LOG.trace("Creating LRUWeakCache with initialCapacity: {}, maximumCacheSize: {}", (Object)initialCapacity, (Object)maximumCacheSize);
        return new CaffeineLRUWeakCache(initialCapacity, maximumCacheSize);
    }

    public <K, V> Map<K, V> createLRUWeakCache(int initialCapacity, int maximumCacheSize, boolean stopOnEviction) {
        LOG.trace("Creating LRUWeakCache with initialCapacity: {}, maximumCacheSize: {}, stopOnEviction: {}", new Object[]{initialCapacity, maximumCacheSize, stopOnEviction});
        return new CaffeineLRUWeakCache(initialCapacity, maximumCacheSize, stopOnEviction);
    }

    public String toString() {
        return "camel-caffeine-lrucache";
    }

    static {
        boolean warmUp = "true".equalsIgnoreCase(System.getProperty("CamelWarmUpLRUCacheFactory", "true"));
        if (warmUp) {
            CaffeineLRUCacheFactory.warmUp();
        }
    }
}

