/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.io.etcd.jetcd.auth;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.kyuubi.shade.io.etcd.jetcd.ByteSequence;
import org.apache.kyuubi.shade.io.etcd.jetcd.auth.Permission;
import org.apache.kyuubi.shade.io.etcd.jetcd.impl.AbstractResponse;

public class AuthRoleGetResponse
extends AbstractResponse<org.apache.kyuubi.shade.io.etcd.jetcd.api.AuthRoleGetResponse> {
    private List<Permission> permissions;

    public AuthRoleGetResponse(org.apache.kyuubi.shade.io.etcd.jetcd.api.AuthRoleGetResponse response) {
        super(response, response.getHeader());
    }

    private static Permission toPermission(org.apache.kyuubi.shade.io.etcd.jetcd.api.Permission perm) {
        Permission.Type type;
        ByteSequence key = ByteSequence.from(perm.getKey());
        ByteSequence rangeEnd = ByteSequence.from(perm.getRangeEnd());
        switch (perm.getPermType()) {
            case READ: {
                type = Permission.Type.READ;
                break;
            }
            case WRITE: {
                type = Permission.Type.WRITE;
                break;
            }
            case READWRITE: {
                type = Permission.Type.READWRITE;
                break;
            }
            default: {
                type = Permission.Type.UNRECOGNIZED;
            }
        }
        return new Permission(type, key, rangeEnd);
    }

    public synchronized List<Permission> getPermissions() {
        if (this.permissions == null) {
            this.permissions = ((org.apache.kyuubi.shade.io.etcd.jetcd.api.AuthRoleGetResponse)this.getResponse()).getPermList().stream().map(AuthRoleGetResponse::toPermission).collect(Collectors.toList());
        }
        return this.permissions;
    }
}

