/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene95;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.lucene.codecs.hnsw.FlatVectorsScorer;
import org.apache.lucene.codecs.lucene90.IndexedDISI;
import org.apache.lucene.codecs.lucene95.HasIndexSlice;
import org.apache.lucene.codecs.lucene95.OrdToDocDISIReaderConfiguration;
import org.apache.lucene.index.ByteVectorValues;
import org.apache.lucene.index.KnnVectorValues;
import org.apache.lucene.index.VectorEncoding;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.VectorScorer;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.RandomAccessInput;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.hnsw.RandomVectorScorer;
import org.apache.lucene.util.packed.DirectMonotonicReader;

public abstract class OffHeapByteVectorValues
extends ByteVectorValues
implements HasIndexSlice {
    protected final int dimension;
    protected final int size;
    protected final IndexInput slice;
    protected int lastOrd = -1;
    protected final byte[] binaryValue;
    protected final ByteBuffer byteBuffer;
    protected final int byteSize;
    protected final VectorSimilarityFunction similarityFunction;
    protected final FlatVectorsScorer flatVectorsScorer;

    OffHeapByteVectorValues(int dimension, int size, IndexInput slice, int byteSize, FlatVectorsScorer flatVectorsScorer, VectorSimilarityFunction similarityFunction) {
        this.dimension = dimension;
        this.size = size;
        this.slice = slice;
        this.byteSize = byteSize;
        this.byteBuffer = ByteBuffer.allocate(byteSize);
        this.binaryValue = this.byteBuffer.array();
        this.similarityFunction = similarityFunction;
        this.flatVectorsScorer = flatVectorsScorer;
    }

    @Override
    public int dimension() {
        return this.dimension;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public byte[] vectorValue(int targetOrd) throws IOException {
        if (this.lastOrd != targetOrd) {
            this.readValue(targetOrd);
            this.lastOrd = targetOrd;
        }
        return this.binaryValue;
    }

    @Override
    public IndexInput getSlice() {
        return this.slice;
    }

    private void readValue(int targetOrd) throws IOException {
        this.slice.seek((long)targetOrd * (long)this.byteSize);
        this.slice.readBytes(this.byteBuffer.array(), this.byteBuffer.arrayOffset(), this.byteSize);
    }

    public static OffHeapByteVectorValues load(VectorSimilarityFunction vectorSimilarityFunction, FlatVectorsScorer flatVectorsScorer, OrdToDocDISIReaderConfiguration configuration, VectorEncoding vectorEncoding, int dimension, long vectorDataOffset, long vectorDataLength, IndexInput vectorData) throws IOException {
        if (configuration.isEmpty() || vectorEncoding != VectorEncoding.BYTE) {
            return new EmptyOffHeapVectorValues(dimension, flatVectorsScorer, vectorSimilarityFunction);
        }
        IndexInput bytesSlice = vectorData.slice("vector-data", vectorDataOffset, vectorDataLength);
        if (configuration.isDense()) {
            return new DenseOffHeapVectorValues(dimension, configuration.size, bytesSlice, dimension, flatVectorsScorer, vectorSimilarityFunction);
        }
        return new SparseOffHeapVectorValues(configuration, vectorData, bytesSlice, dimension, dimension, flatVectorsScorer, vectorSimilarityFunction);
    }

    private static class EmptyOffHeapVectorValues
    extends OffHeapByteVectorValues {
        public EmptyOffHeapVectorValues(int dimension, FlatVectorsScorer flatVectorsScorer, VectorSimilarityFunction vectorSimilarityFunction) {
            super(dimension, 0, null, 0, flatVectorsScorer, vectorSimilarityFunction);
        }

        @Override
        public int dimension() {
            return super.dimension();
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public byte[] vectorValue(int ord) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public KnnVectorValues.DocIndexIterator iterator() {
            return this.createDenseIterator();
        }

        @Override
        public EmptyOffHeapVectorValues copy() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int ordToDoc(int ord) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Bits getAcceptOrds(Bits acceptDocs) {
            return null;
        }

        @Override
        public VectorScorer scorer(byte[] query) {
            return null;
        }
    }

    public static class DenseOffHeapVectorValues
    extends OffHeapByteVectorValues {
        public DenseOffHeapVectorValues(int dimension, int size, IndexInput slice, int byteSize, FlatVectorsScorer flatVectorsScorer, VectorSimilarityFunction vectorSimilarityFunction) {
            super(dimension, size, slice, byteSize, flatVectorsScorer, vectorSimilarityFunction);
        }

        @Override
        public DenseOffHeapVectorValues copy() throws IOException {
            return new DenseOffHeapVectorValues(this.dimension, this.size, this.slice.clone(), this.byteSize, this.flatVectorsScorer, this.similarityFunction);
        }

        @Override
        public KnnVectorValues.DocIndexIterator iterator() {
            return this.createDenseIterator();
        }

        @Override
        public Bits getAcceptOrds(Bits acceptDocs) {
            return acceptDocs;
        }

        @Override
        public VectorScorer scorer(byte[] query) throws IOException {
            DenseOffHeapVectorValues copy = this.copy();
            final KnnVectorValues.DocIndexIterator iterator = copy.iterator();
            final RandomVectorScorer scorer = this.flatVectorsScorer.getRandomVectorScorer(this.similarityFunction, (KnnVectorValues)copy, query);
            return new VectorScorer(){

                @Override
                public float score() throws IOException {
                    return scorer.score(iterator.docID());
                }

                @Override
                public DocIdSetIterator iterator() {
                    return iterator;
                }

                @Override
                public VectorScorer.Bulk bulk(DocIdSetIterator matchingDocs) {
                    return VectorScorer.Bulk.fromRandomScorerDense(scorer, iterator, matchingDocs);
                }
            };
        }
    }

    private static class SparseOffHeapVectorValues
    extends OffHeapByteVectorValues {
        private final DirectMonotonicReader ordToDoc;
        private final IndexedDISI disi;
        private final IndexInput dataIn;
        private final OrdToDocDISIReaderConfiguration configuration;

        public SparseOffHeapVectorValues(OrdToDocDISIReaderConfiguration configuration, IndexInput dataIn, IndexInput slice, int dimension, int byteSize, FlatVectorsScorer flatVectorsScorer, VectorSimilarityFunction vectorSimilarityFunction) throws IOException {
            super(dimension, configuration.size, slice, byteSize, flatVectorsScorer, vectorSimilarityFunction);
            this.configuration = configuration;
            RandomAccessInput addressesData = dataIn.randomAccessSlice(configuration.addressesOffset, configuration.addressesLength);
            this.dataIn = dataIn;
            this.ordToDoc = DirectMonotonicReader.getInstance(configuration.meta, addressesData);
            this.disi = new IndexedDISI(dataIn, configuration.docsWithFieldOffset, configuration.docsWithFieldLength, configuration.jumpTableEntryCount, configuration.denseRankPower, configuration.size);
        }

        @Override
        public SparseOffHeapVectorValues copy() throws IOException {
            return new SparseOffHeapVectorValues(this.configuration, this.dataIn, this.slice.clone(), this.dimension, this.byteSize, this.flatVectorsScorer, this.similarityFunction);
        }

        @Override
        public int ordToDoc(int ord) {
            return (int)this.ordToDoc.get(ord);
        }

        @Override
        public KnnVectorValues.DocIndexIterator iterator() {
            return IndexedDISI.asDocIndexIterator(this.disi);
        }

        @Override
        public Bits getAcceptOrds(final Bits acceptDocs) {
            if (acceptDocs == null) {
                return null;
            }
            return new Bits(){

                @Override
                public boolean get(int index) {
                    return acceptDocs.get(this.ordToDoc(index));
                }

                @Override
                public int length() {
                    return size;
                }
            };
        }

        @Override
        public VectorScorer scorer(byte[] query) throws IOException {
            final SparseOffHeapVectorValues copy = this.copy();
            final RandomVectorScorer scorer = this.flatVectorsScorer.getRandomVectorScorer(this.similarityFunction, (KnnVectorValues)copy, query);
            final KnnVectorValues.DocIndexIterator iterator = copy.iterator();
            return new VectorScorer(){

                @Override
                public float score() throws IOException {
                    return scorer.score(copy.disi.index());
                }

                @Override
                public DocIdSetIterator iterator() {
                    return iterator;
                }

                @Override
                public VectorScorer.Bulk bulk(DocIdSetIterator matchingDocs) {
                    return VectorScorer.Bulk.fromRandomScorerSparse(scorer, iterator, matchingDocs);
                }
            };
        }
    }
}

