/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.tests.codecs.blockterms;

import java.io.IOException;
import org.apache.lucene.codecs.FieldsConsumer;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.codecs.PostingsReaderBase;
import org.apache.lucene.codecs.PostingsWriterBase;
import org.apache.lucene.codecs.blockterms.BlockTermsReader;
import org.apache.lucene.codecs.blockterms.BlockTermsWriter;
import org.apache.lucene.codecs.blockterms.TermsIndexReaderBase;
import org.apache.lucene.codecs.blockterms.TermsIndexWriterBase;
import org.apache.lucene.codecs.blockterms.VariableGapTermsIndexReader;
import org.apache.lucene.codecs.blockterms.VariableGapTermsIndexWriter;
import org.apache.lucene.codecs.lucene104.Lucene104PostingsReader;
import org.apache.lucene.codecs.lucene104.Lucene104PostingsWriter;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;

public final class LuceneVarGapDocFreqInterval
extends PostingsFormat {
    final int termIndexInterval;
    final int docFreqThreshold;
    static final String FREQ_EXTENSION = "frq";
    static final String PROX_EXTENSION = "prx";

    public LuceneVarGapDocFreqInterval() {
        this(1000000, 32);
    }

    public LuceneVarGapDocFreqInterval(int docFreqThreshold, int termIndexInterval) {
        super("LuceneVarGapDocFreqInterval");
        this.termIndexInterval = termIndexInterval;
        this.docFreqThreshold = docFreqThreshold;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FieldsConsumer fieldsConsumer(SegmentWriteState state) throws IOException {
        VariableGapTermsIndexWriter indexWriter;
        Lucene104PostingsWriter docs = new Lucene104PostingsWriter(state);
        boolean success = false;
        try {
            indexWriter = new VariableGapTermsIndexWriter(state, (VariableGapTermsIndexWriter.IndexTermSelector)new VariableGapTermsIndexWriter.EveryNOrDocFreqTermSelector(this.docFreqThreshold, this.termIndexInterval));
            success = true;
        }
        finally {
            if (!success) {
                docs.close();
            }
        }
        success = false;
        try {
            BlockTermsWriter ret = new BlockTermsWriter((TermsIndexWriterBase)indexWriter, state, (PostingsWriterBase)docs);
            success = true;
            BlockTermsWriter blockTermsWriter = ret;
            return blockTermsWriter;
        }
        finally {
            if (!success) {
                try {
                    docs.close();
                }
                finally {
                    indexWriter.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FieldsProducer fieldsProducer(SegmentReadState state) throws IOException {
        VariableGapTermsIndexReader indexReader;
        Lucene104PostingsReader postings = new Lucene104PostingsReader(state);
        boolean success = false;
        try {
            indexReader = new VariableGapTermsIndexReader(state);
            success = true;
        }
        finally {
            if (!success) {
                postings.close();
            }
        }
        success = false;
        try {
            BlockTermsReader ret = new BlockTermsReader((TermsIndexReaderBase)indexReader, (PostingsReaderBase)postings, state);
            success = true;
            BlockTermsReader blockTermsReader = ret;
            return blockTermsReader;
        }
        finally {
            if (!success) {
                try {
                    postings.close();
                }
                finally {
                    indexReader.close();
                }
            }
        }
    }
}

