/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.application;

import jakarta.faces.application.Application;
import jakarta.faces.application.ApplicationFactory;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.myfaces.application.ApplicationImpl;
import org.apache.myfaces.core.api.shared.lang.Assert;
import org.apache.myfaces.util.Purgeable;

public class ApplicationFactoryImpl
extends ApplicationFactory
implements Purgeable {
    private static final Logger log = Logger.getLogger(ApplicationFactoryImpl.class.getName());
    private Application _application;
    private boolean _myfacesInstanceAddedToApplicationMap = false;

    public ApplicationFactoryImpl() {
        this.createAndLogNewApplication();
    }

    private void createAndLogNewApplication() {
        this._application = new ApplicationImpl();
        this.putApplicationOnMap();
        if (log.isLoggable(Level.FINEST)) {
            log.finest("New ApplicationFactory instance created");
        }
    }

    @Override
    public void purge() {
        this.createAndLogNewApplication();
    }

    public Application getApplication() {
        if (this._application != null && !this._myfacesInstanceAddedToApplicationMap) {
            this.putApplicationOnMap();
        }
        return this._application;
    }

    public void setApplication(Application application) {
        Assert.notNull((Object)application, (String)"application");
        this._application = application;
        this.putApplicationOnMap();
    }

    private void putApplicationOnMap() {
        ExternalContext externalContext;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext != null && (externalContext = facesContext.getExternalContext()) != null) {
            externalContext.getApplicationMap().put("org.apache.myfaces.application.ApplicationImpl", this._application);
            this._myfacesInstanceAddedToApplicationMap = true;
        }
    }
}

