/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import okhttp3.CacheControl;
import okhttp3.Headers;
import okhttp3.internal._UtilCommonKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0000\u001a\f\u0010\u0003\u001a\u00020\u0004*\u00020\u0005H\u0000\u001a\f\u0010\u0006\u001a\u00020\u0002*\u00020\u0007H\u0000\u001a\f\u0010\b\u001a\u00020\u0002*\u00020\u0007H\u0000\u001a\f\u0010\t\u001a\u00020\u0002*\u00020\nH\u0000\u001a\f\u0010\u000b\u001a\u00020\n*\u00020\nH\u0000\u001a\f\u0010\f\u001a\u00020\n*\u00020\nH\u0000\u001a\f\u0010\r\u001a\u00020\n*\u00020\nH\u0000\u001a\f\u0010\u000e\u001a\u00020\n*\u00020\nH\u0000\u001a\f\u0010\u000f\u001a\u00020\n*\u00020\nH\u0000\u001a\u0014\u0010\u0010\u001a\u00020\u0002*\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u001a\u001e\u0010\u0013\u001a\u00020\u0004*\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u00012\b\b\u0002\u0010\u0015\u001a\u00020\u0004H\u0002\u00a8\u0006\u0016"}, d2={"commonToString", "", "Lokhttp3/CacheControl;", "commonClampToInt", "", "", "commonForceNetwork", "Lokhttp3/CacheControl$Companion;", "commonForceCache", "commonBuild", "Lokhttp3/CacheControl$Builder;", "commonNoCache", "commonNoStore", "commonOnlyIfCached", "commonNoTransform", "commonImmutable", "commonParse", "headers", "Lokhttp3/Headers;", "indexOfElement", "characters", "startIndex", "okhttp"})
public final class _CacheControlCommonKt {
    @NotNull
    public static final String commonToString(@NotNull CacheControl $this$commonToString) {
        Intrinsics.checkNotNullParameter((Object)$this$commonToString, (String)"<this>");
        String result = $this$commonToString.getHeaderValue$okhttp();
        if (result == null) {
            StringBuilder stringBuilder;
            StringBuilder $this$commonToString_u24lambda_u240 = stringBuilder = new StringBuilder();
            boolean bl = false;
            if ($this$commonToString.noCache()) {
                $this$commonToString_u24lambda_u240.append("no-cache, ");
            }
            if ($this$commonToString.noStore()) {
                $this$commonToString_u24lambda_u240.append("no-store, ");
            }
            if ($this$commonToString.maxAgeSeconds() != -1) {
                $this$commonToString_u24lambda_u240.append("max-age=").append($this$commonToString.maxAgeSeconds()).append(", ");
            }
            if ($this$commonToString.sMaxAgeSeconds() != -1) {
                $this$commonToString_u24lambda_u240.append("s-maxage=").append($this$commonToString.sMaxAgeSeconds()).append(", ");
            }
            if ($this$commonToString.isPrivate()) {
                $this$commonToString_u24lambda_u240.append("private, ");
            }
            if ($this$commonToString.isPublic()) {
                $this$commonToString_u24lambda_u240.append("public, ");
            }
            if ($this$commonToString.mustRevalidate()) {
                $this$commonToString_u24lambda_u240.append("must-revalidate, ");
            }
            if ($this$commonToString.maxStaleSeconds() != -1) {
                $this$commonToString_u24lambda_u240.append("max-stale=").append($this$commonToString.maxStaleSeconds()).append(", ");
            }
            if ($this$commonToString.minFreshSeconds() != -1) {
                $this$commonToString_u24lambda_u240.append("min-fresh=").append($this$commonToString.minFreshSeconds()).append(", ");
            }
            if ($this$commonToString.onlyIfCached()) {
                $this$commonToString_u24lambda_u240.append("only-if-cached, ");
            }
            if ($this$commonToString.noTransform()) {
                $this$commonToString_u24lambda_u240.append("no-transform, ");
            }
            if ($this$commonToString.immutable()) {
                $this$commonToString_u24lambda_u240.append("immutable, ");
            }
            if (((CharSequence)$this$commonToString_u24lambda_u240).length() == 0) {
                return "";
            }
            Intrinsics.checkNotNullExpressionValue((Object)$this$commonToString_u24lambda_u240.delete($this$commonToString_u24lambda_u240.length() - 2, $this$commonToString_u24lambda_u240.length()), (String)"delete(...)");
            result = stringBuilder.toString();
            $this$commonToString.setHeaderValue$okhttp(result);
        }
        return result;
    }

    public static final int commonClampToInt(long $this$commonClampToInt) {
        return $this$commonClampToInt > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)$this$commonClampToInt;
    }

    @NotNull
    public static final CacheControl commonForceNetwork(@NotNull CacheControl.Companion $this$commonForceNetwork) {
        Intrinsics.checkNotNullParameter((Object)$this$commonForceNetwork, (String)"<this>");
        return new CacheControl.Builder().noCache().build();
    }

    @NotNull
    public static final CacheControl commonForceCache(@NotNull CacheControl.Companion $this$commonForceCache) {
        Intrinsics.checkNotNullParameter((Object)$this$commonForceCache, (String)"<this>");
        return new CacheControl.Builder().onlyIfCached().maxStale-LRDsOJo(DurationKt.toDuration((int)Integer.MAX_VALUE, (DurationUnit)DurationUnit.SECONDS)).build();
    }

    @NotNull
    public static final CacheControl commonBuild(@NotNull CacheControl.Builder $this$commonBuild) {
        Intrinsics.checkNotNullParameter((Object)$this$commonBuild, (String)"<this>");
        return new CacheControl($this$commonBuild.getNoCache$okhttp(), $this$commonBuild.getNoStore$okhttp(), $this$commonBuild.getMaxAgeSeconds$okhttp(), -1, false, false, false, $this$commonBuild.getMaxStaleSeconds$okhttp(), $this$commonBuild.getMinFreshSeconds$okhttp(), $this$commonBuild.getOnlyIfCached$okhttp(), $this$commonBuild.getNoTransform$okhttp(), $this$commonBuild.getImmutable$okhttp(), null);
    }

    @NotNull
    public static final CacheControl.Builder commonNoCache(@NotNull CacheControl.Builder $this$commonNoCache) {
        CacheControl.Builder builder;
        Intrinsics.checkNotNullParameter((Object)$this$commonNoCache, (String)"<this>");
        CacheControl.Builder $this$commonNoCache_u24lambda_u240 = builder = $this$commonNoCache;
        boolean bl = false;
        $this$commonNoCache_u24lambda_u240.setNoCache$okhttp(true);
        return builder;
    }

    @NotNull
    public static final CacheControl.Builder commonNoStore(@NotNull CacheControl.Builder $this$commonNoStore) {
        CacheControl.Builder builder;
        Intrinsics.checkNotNullParameter((Object)$this$commonNoStore, (String)"<this>");
        CacheControl.Builder $this$commonNoStore_u24lambda_u240 = builder = $this$commonNoStore;
        boolean bl = false;
        $this$commonNoStore_u24lambda_u240.setNoStore$okhttp(true);
        return builder;
    }

    @NotNull
    public static final CacheControl.Builder commonOnlyIfCached(@NotNull CacheControl.Builder $this$commonOnlyIfCached) {
        CacheControl.Builder builder;
        Intrinsics.checkNotNullParameter((Object)$this$commonOnlyIfCached, (String)"<this>");
        CacheControl.Builder $this$commonOnlyIfCached_u24lambda_u240 = builder = $this$commonOnlyIfCached;
        boolean bl = false;
        $this$commonOnlyIfCached_u24lambda_u240.setOnlyIfCached$okhttp(true);
        return builder;
    }

    @NotNull
    public static final CacheControl.Builder commonNoTransform(@NotNull CacheControl.Builder $this$commonNoTransform) {
        CacheControl.Builder builder;
        Intrinsics.checkNotNullParameter((Object)$this$commonNoTransform, (String)"<this>");
        CacheControl.Builder $this$commonNoTransform_u24lambda_u240 = builder = $this$commonNoTransform;
        boolean bl = false;
        $this$commonNoTransform_u24lambda_u240.setNoTransform$okhttp(true);
        return builder;
    }

    @NotNull
    public static final CacheControl.Builder commonImmutable(@NotNull CacheControl.Builder $this$commonImmutable) {
        CacheControl.Builder builder;
        Intrinsics.checkNotNullParameter((Object)$this$commonImmutable, (String)"<this>");
        CacheControl.Builder $this$commonImmutable_u24lambda_u240 = builder = $this$commonImmutable;
        boolean bl = false;
        $this$commonImmutable_u24lambda_u240.setImmutable$okhttp(true);
        return builder;
    }

    @NotNull
    public static final CacheControl commonParse(@NotNull CacheControl.Companion $this$commonParse, @NotNull Headers headers) {
        Intrinsics.checkNotNullParameter((Object)$this$commonParse, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
        boolean noCache = false;
        boolean noStore = false;
        int maxAgeSeconds = -1;
        int sMaxAgeSeconds = -1;
        boolean isPrivate = false;
        boolean isPublic = false;
        boolean mustRevalidate = false;
        int maxStaleSeconds = -1;
        int minFreshSeconds = -1;
        boolean onlyIfCached = false;
        boolean noTransform = false;
        boolean immutable = false;
        boolean canUseHeaderValue = true;
        String headerValue = null;
        int n = headers.size();
        for (int i = 0; i < n; ++i) {
            String name = headers.name(i);
            String value = headers.value(i);
            if (StringsKt.equals((String)name, (String)"Cache-Control", (boolean)true)) {
                if (headerValue != null) {
                    canUseHeaderValue = false;
                } else {
                    headerValue = value;
                }
            } else {
                if (!StringsKt.equals((String)name, (String)"Pragma", (boolean)true)) continue;
                canUseHeaderValue = false;
            }
            int pos = 0;
            while (pos < value.length()) {
                int tokenStart = pos;
                pos = _CacheControlCommonKt.indexOfElement(value, "=,;", pos);
                String string = value.substring(tokenStart, pos);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                String directive = ((Object)StringsKt.trim((CharSequence)string)).toString();
                String parameter = null;
                if (pos == value.length() || value.charAt(pos) == ',' || value.charAt(pos) == ';') {
                    ++pos;
                    parameter = null;
                } else {
                    int parameterStart;
                    ++pos;
                    if ((pos = _UtilCommonKt.indexOfNonWhitespace(value, pos)) < value.length() && value.charAt(pos) == '\"') {
                        parameterStart = ++pos;
                        pos = StringsKt.indexOf$default((CharSequence)value, (char)'\"', (int)pos, (boolean)false, (int)4, null);
                        String string2 = value.substring(parameterStart, pos);
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                        parameter = string2;
                        ++pos;
                    } else {
                        parameterStart = pos;
                        pos = _CacheControlCommonKt.indexOfElement(value, ",;", pos);
                        String string3 = value.substring(parameterStart, pos);
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                        parameter = ((Object)StringsKt.trim((CharSequence)string3)).toString();
                    }
                }
                if (StringsKt.equals((String)"no-cache", (String)directive, (boolean)true)) {
                    noCache = true;
                    continue;
                }
                if (StringsKt.equals((String)"no-store", (String)directive, (boolean)true)) {
                    noStore = true;
                    continue;
                }
                if (StringsKt.equals((String)"max-age", (String)directive, (boolean)true)) {
                    maxAgeSeconds = _UtilCommonKt.toNonNegativeInt(parameter, -1);
                    continue;
                }
                if (StringsKt.equals((String)"s-maxage", (String)directive, (boolean)true)) {
                    sMaxAgeSeconds = _UtilCommonKt.toNonNegativeInt(parameter, -1);
                    continue;
                }
                if (StringsKt.equals((String)"private", (String)directive, (boolean)true)) {
                    isPrivate = true;
                    continue;
                }
                if (StringsKt.equals((String)"public", (String)directive, (boolean)true)) {
                    isPublic = true;
                    continue;
                }
                if (StringsKt.equals((String)"must-revalidate", (String)directive, (boolean)true)) {
                    mustRevalidate = true;
                    continue;
                }
                if (StringsKt.equals((String)"max-stale", (String)directive, (boolean)true)) {
                    maxStaleSeconds = _UtilCommonKt.toNonNegativeInt(parameter, Integer.MAX_VALUE);
                    continue;
                }
                if (StringsKt.equals((String)"min-fresh", (String)directive, (boolean)true)) {
                    minFreshSeconds = _UtilCommonKt.toNonNegativeInt(parameter, -1);
                    continue;
                }
                if (StringsKt.equals((String)"only-if-cached", (String)directive, (boolean)true)) {
                    onlyIfCached = true;
                    continue;
                }
                if (StringsKt.equals((String)"no-transform", (String)directive, (boolean)true)) {
                    noTransform = true;
                    continue;
                }
                if (!StringsKt.equals((String)"immutable", (String)directive, (boolean)true)) continue;
                immutable = true;
            }
        }
        if (!canUseHeaderValue) {
            headerValue = null;
        }
        return new CacheControl(noCache, noStore, maxAgeSeconds, sMaxAgeSeconds, isPrivate, isPublic, mustRevalidate, maxStaleSeconds, minFreshSeconds, onlyIfCached, noTransform, immutable, headerValue);
    }

    private static final int indexOfElement(String $this$indexOfElement, String characters, int startIndex) {
        int n = $this$indexOfElement.length();
        for (int i = startIndex; i < n; ++i) {
            if (!StringsKt.contains$default((CharSequence)characters, (char)$this$indexOfElement.charAt(i), (boolean)false, (int)2, null)) continue;
            return i;
        }
        return $this$indexOfElement.length();
    }

    static /* synthetic */ int indexOfElement$default(String string, String string2, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return _CacheControlCommonKt.indexOfElement(string, string2, n);
    }
}

