/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.authentication.logout;

import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.security.web.util.UrlUtils;
import org.springframework.util.Assert;

public class ForwardLogoutSuccessHandler
implements LogoutSuccessHandler {
    private final String targetUrl;

    public ForwardLogoutSuccessHandler(String targetUrl) {
        Assert.isTrue((boolean)UrlUtils.isValidRedirectUrl(targetUrl), () -> "'" + targetUrl + "' is not a valid target URL");
        this.targetUrl = targetUrl;
    }

    @Override
    public void onLogoutSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
        request.getRequestDispatcher(this.targetUrl).forward((ServletRequest)request, (ServletResponse)response);
    }
}

