/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.security.config.annotation.ObjectPostProcessor;
import org.springframework.security.config.annotation.SecurityBuilder;
import org.springframework.security.config.annotation.SecurityConfigurer;
import org.springframework.util.Assert;

public abstract class SecurityConfigurerAdapter<O, B extends SecurityBuilder<O>>
implements SecurityConfigurer<O, B> {
    private B securityBuilder;
    private CompositeObjectPostProcessor objectPostProcessor = new CompositeObjectPostProcessor();

    @Override
    public void init(B builder) throws Exception {
    }

    @Override
    public void configure(B builder) throws Exception {
    }

    @Deprecated(since="6.1", forRemoval=true)
    public B and() {
        return this.getBuilder();
    }

    protected final B getBuilder() {
        Assert.state((this.securityBuilder != null ? 1 : 0) != 0, (String)"securityBuilder cannot be null");
        return this.securityBuilder;
    }

    protected <T> T postProcess(T object) {
        return (T)this.objectPostProcessor.postProcess(object);
    }

    public void addObjectPostProcessor(org.springframework.security.config.ObjectPostProcessor<?> objectPostProcessor) {
        this.objectPostProcessor.addObjectPostProcessor(objectPostProcessor);
    }

    @Deprecated(since="6.4", forRemoval=true)
    public void addObjectPostProcessor(ObjectPostProcessor<?> objectPostProcessor) {
        this.objectPostProcessor.addObjectPostProcessor(objectPostProcessor);
    }

    public void setBuilder(B builder) {
        this.securityBuilder = builder;
    }

    private static final class CompositeObjectPostProcessor
    implements org.springframework.security.config.ObjectPostProcessor<Object> {
        private List<org.springframework.security.config.ObjectPostProcessor<?>> postProcessors = new ArrayList();

        private CompositeObjectPostProcessor() {
        }

        @Override
        public Object postProcess(Object object) {
            for (org.springframework.security.config.ObjectPostProcessor<?> opp : this.postProcessors) {
                Class<?> oppClass = opp.getClass();
                Class oppType = GenericTypeResolver.resolveTypeArgument(oppClass, org.springframework.security.config.ObjectPostProcessor.class);
                if (oppType != null && !oppType.isAssignableFrom(object.getClass())) continue;
                object = opp.postProcess(object);
            }
            return object;
        }

        private boolean addObjectPostProcessor(org.springframework.security.config.ObjectPostProcessor<?> objectPostProcessor) {
            boolean result = this.postProcessors.add(objectPostProcessor);
            this.postProcessors.sort((Comparator<org.springframework.security.config.ObjectPostProcessor<?>>)AnnotationAwareOrderComparator.INSTANCE);
            return result;
        }
    }
}

