/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.insight;

import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.ozone.insight.BaseInsightSubCommand;
import org.apache.hadoop.ozone.insight.InsightPoint;
import picocli.CommandLine;

@CommandLine.Command(name="list", description={"Show available insight points."}, mixinStandardHelpOptions=true, versionProvider=HddsVersionProvider.class)
public class ListSubCommand
extends BaseInsightSubCommand
implements Callable<Void> {
    @CommandLine.Parameters(defaultValue="")
    private String insightPrefix;

    @Override
    public Void call() throws Exception {
        System.out.println("Available insight points:\n\n");
        Map<String, InsightPoint> insightPoints = this.createInsightPoints(new OzoneConfiguration());
        for (Map.Entry<String, InsightPoint> entry : insightPoints.entrySet()) {
            if (this.insightPrefix != null && !entry.getKey().startsWith(this.insightPrefix)) continue;
            System.out.println(String.format("  %-33s    %s", entry.getKey(), entry.getValue().getDescription()));
        }
        return null;
    }
}

