/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.repair.om;

import jakarta.annotation.Nonnull;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Stack;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.hdds.utils.db.ByteArrayCodec;
import org.apache.hadoop.hdds.utils.db.Codec;
import org.apache.hadoop.hdds.utils.db.DBStore;
import org.apache.hadoop.hdds.utils.db.DBStoreBuilder;
import org.apache.hadoop.hdds.utils.db.StringCodec;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.hdds.utils.db.TypedTable;
import org.apache.hadoop.ozone.OmUtils;
import org.apache.hadoop.ozone.om.OmMetadataManagerImpl;
import org.apache.hadoop.ozone.om.codec.OMDBDefinition;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmDirectoryInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmVolumeArgs;
import org.apache.hadoop.ozone.om.helpers.RepeatedOmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.SnapshotInfo;
import org.apache.hadoop.ozone.om.helpers.WithObjectID;
import org.apache.hadoop.ozone.om.request.file.OMFileRequest;
import org.apache.hadoop.ozone.repair.RepairTool;
import org.apache.ratis.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="fso-tree", description={"Identify and repair a disconnected FSO tree by marking unreferenced (orphaned) entries for deletion. OM should be stopped while this tool is run."})
public class FSORepairTool
extends RepairTool {
    private static final Logger LOG = LoggerFactory.getLogger(FSORepairTool.class);
    private static final String REACHABLE_TABLE = "reachable";
    private static final String UNREACHABLE_TABLE = "unreachable";
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    @CommandLine.Option(names={"--db"}, required=true, description={"Path to OM RocksDB"})
    private String omDBPath;
    @CommandLine.Option(names={"-v", "--volume"}, description={"Filter by volume name. Add '/' before the volume name."})
    private String volumeFilter;
    @CommandLine.Option(names={"-b", "--bucket"}, description={"Filter by bucket name"})
    private String bucketFilter;

    @Override
    @Nonnull
    protected RepairTool.Component serviceToBeOffline() {
        return RepairTool.Component.OM;
    }

    @Override
    public void execute() throws Exception {
        try {
            Impl repairTool = new Impl();
            repairTool.run();
        }
        catch (Exception ex) {
            LOG.error("FSO repair failed", (Throwable)ex);
            throw new IllegalArgumentException("FSO repair failed: " + ex.getMessage());
        }
        if (this.isVerbose()) {
            this.info("FSO repair finished.", new Object[0]);
        }
    }

    protected static DBStore getStoreFromPath(String dbPath) throws IOException {
        File omDBFile = new File(dbPath);
        if (!omDBFile.exists() || !omDBFile.isDirectory()) {
            throw new IOException(String.format("Specified OM DB instance %s does not exist or is not a RocksDB directory.", dbPath));
        }
        return OmMetadataManagerImpl.loadDB((OzoneConfiguration)new OzoneConfiguration(), (File)new File(dbPath).getParentFile(), (int)-1);
    }

    private static String buildReachableKey(OmVolumeArgs volume, OmBucketInfo bucket, WithObjectID object) {
        return "/" + volume.getObjectID() + "/" + bucket.getObjectID() + "/" + object.getObjectID();
    }

    private static String buildReachableParentKey(String fileOrDirKey) {
        String[] keyParts = fileOrDirKey.split("/");
        Preconditions.assertTrue((keyParts.length >= 4 ? 1 : 0) != 0);
        String volumeID = keyParts[1];
        String bucketID = keyParts[2];
        String parentID = keyParts[3];
        return "/" + volumeID + "/" + bucketID + "/" + parentID;
    }

    private class Impl {
        private final DBStore store;
        private final Table<String, OmVolumeArgs> volumeTable;
        private final Table<String, OmBucketInfo> bucketTable;
        private final Table<String, OmDirectoryInfo> directoryTable;
        private final Table<String, OmKeyInfo> fileTable;
        private final Table<String, OmKeyInfo> deletedDirectoryTable;
        private final Table<String, RepeatedOmKeyInfo> deletedTable;
        private final Table<String, SnapshotInfo> snapshotInfoTable;
        private DBStore tempDB;
        private TypedTable<String, byte[]> reachableTable;
        private TypedTable<String, byte[]> unreachableTable;
        private final ReportStatistics reachableStats = new ReportStatistics(0L, 0L, 0L);
        private final ReportStatistics unreachableStats = new ReportStatistics(0L, 0L, 0L);
        private final ReportStatistics unreferencedStats = new ReportStatistics(0L, 0L, 0L);

        Impl() throws IOException {
            this.store = FSORepairTool.getStoreFromPath(FSORepairTool.this.omDBPath);
            this.volumeTable = OMDBDefinition.VOLUME_TABLE_DEF.getTable(this.store);
            this.bucketTable = OMDBDefinition.BUCKET_TABLE_DEF.getTable(this.store);
            this.directoryTable = OMDBDefinition.DIRECTORY_TABLE_DEF.getTable(this.store);
            this.fileTable = OMDBDefinition.FILE_TABLE_DEF.getTable(this.store);
            this.deletedDirectoryTable = OMDBDefinition.DELETED_DIR_TABLE_DEF.getTable(this.store);
            this.deletedTable = OMDBDefinition.DELETED_TABLE_DEF.getTable(this.store);
            this.snapshotInfoTable = OMDBDefinition.SNAPSHOT_INFO_TABLE_DEF.getTable(this.store);
        }

        public Report run() throws Exception {
            try {
                OmVolumeArgs volumeArgs;
                if (FSORepairTool.this.bucketFilter != null && FSORepairTool.this.volumeFilter == null) {
                    FSORepairTool.this.error("--bucket flag cannot be used without specifying --volume.", new Object[0]);
                    Report report = null;
                    return report;
                }
                if (FSORepairTool.this.volumeFilter != null && (volumeArgs = (OmVolumeArgs)this.volumeTable.getIfExist((Object)FSORepairTool.this.volumeFilter)) == null) {
                    FSORepairTool.this.error("Volume '" + FSORepairTool.this.volumeFilter + "' does not exist.", new Object[0]);
                    Report report = null;
                    return report;
                }
                try (Table.KeyValueIterator volumeIterator = this.volumeTable.iterator();){
                    try {
                        this.openTempDB();
                    }
                    catch (IOException e) {
                        FSORepairTool.this.error("Failed to open reachable database: " + e.getMessage(), new Object[0]);
                        throw e;
                    }
                    block21: while (true) {
                        if (volumeIterator.hasNext()) {
                            Table.KeyValue volumeEntry = (Table.KeyValue)volumeIterator.next();
                            String volumeKey = (String)volumeEntry.getKey();
                            if (FSORepairTool.this.volumeFilter != null && !FSORepairTool.this.volumeFilter.equals(volumeKey)) continue;
                            FSORepairTool.this.info("Processing volume: " + volumeKey, new Object[0]);
                            if (FSORepairTool.this.bucketFilter != null) {
                                OmBucketInfo bucketInfo = (OmBucketInfo)this.bucketTable.getIfExist((Object)(volumeKey + "/" + FSORepairTool.this.bucketFilter));
                                if (bucketInfo == null) {
                                    FSORepairTool.this.error("Bucket '" + FSORepairTool.this.bucketFilter + "' does not exist in volume '" + volumeKey + "'.", new Object[0]);
                                    Report report = null;
                                    return report;
                                }
                                if (bucketInfo.getBucketLayout() != BucketLayout.FILE_SYSTEM_OPTIMIZED) {
                                    FSORepairTool.this.info("Skipping non-FSO bucket " + FSORepairTool.this.bucketFilter, new Object[0]);
                                    continue;
                                }
                                this.processBucket((OmVolumeArgs)volumeEntry.getValue(), bucketInfo);
                                continue;
                            }
                            Table.KeyValueIterator bucketIterator = this.bucketTable.iterator();
                            try {
                                bucketIterator.seek((Object)volumeKey);
                                while (true) {
                                    if (!bucketIterator.hasNext()) continue block21;
                                    Table.KeyValue bucketEntry = (Table.KeyValue)bucketIterator.next();
                                    String bucketKey = (String)bucketEntry.getKey();
                                    OmBucketInfo bucketInfo = (OmBucketInfo)bucketEntry.getValue();
                                    if (bucketInfo.getBucketLayout() != BucketLayout.FILE_SYSTEM_OPTIMIZED) {
                                        FSORepairTool.this.info("Skipping non-FSO bucket " + bucketKey, new Object[0]);
                                        continue;
                                    }
                                    if (!bucketKey.startsWith(volumeKey)) continue block21;
                                    this.processBucket((OmVolumeArgs)volumeEntry.getValue(), bucketInfo);
                                }
                            }
                            finally {
                                if (bucketIterator == null) continue;
                                bucketIterator.close();
                                continue;
                            }
                        }
                        break;
                    }
                }
            }
            catch (IOException e) {
                FSORepairTool.this.error("An error occurred while processing" + e.getMessage(), new Object[0]);
                throw e;
            }
            finally {
                this.closeTempDB();
                this.store.close();
            }
            return this.buildReportAndLog();
        }

        private boolean checkIfSnapshotExistsForBucket(String volumeName, String bucketName) throws IOException {
            if (this.snapshotInfoTable == null) {
                return false;
            }
            try (Table.KeyValueIterator iterator = this.snapshotInfoTable.iterator();){
                while (iterator.hasNext()) {
                    SnapshotInfo snapshotInfo = (SnapshotInfo)((Table.KeyValue)iterator.next()).getValue();
                    String snapshotPath = (volumeName + "/" + bucketName).replaceFirst("^/", "");
                    if (!snapshotInfo.getSnapshotPath().equals(snapshotPath)) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            return false;
        }

        private void processBucket(OmVolumeArgs volume, OmBucketInfo bucketInfo) throws IOException {
            if (this.checkIfSnapshotExistsForBucket(volume.getVolume(), bucketInfo.getBucketName())) {
                FSORepairTool.this.info("Skipping repair for bucket '" + volume.getVolume() + "/" + bucketInfo.getBucketName() + "' due to snapshot presence.", new Object[0]);
                return;
            }
            FSORepairTool.this.info("Processing bucket: " + volume.getVolume() + "/" + bucketInfo.getBucketName(), new Object[0]);
            this.markReachableObjectsInBucket(volume, bucketInfo);
            this.markUnreachableObjectsInBucket(volume, bucketInfo);
            this.handleUnreachableAndUnreferencedObjects(volume, bucketInfo);
        }

        private Report buildReportAndLog() {
            Report report = new Report.Builder().setReachable(this.reachableStats).setUnreachable(this.unreachableStats).setUnreferenced(this.unreferencedStats).build();
            FSORepairTool.this.info("\n" + report, new Object[0]);
            return report;
        }

        private void markReachableObjectsInBucket(OmVolumeArgs volume, OmBucketInfo bucket) throws IOException {
            Stack<String> dirKeyStack = new Stack<String>();
            this.addReachableEntry(volume, bucket, (WithObjectID)bucket);
            Collection<String> childDirs = this.getChildDirectoriesAndMarkAsReachable(volume, bucket, (WithObjectID)bucket);
            dirKeyStack.addAll(childDirs);
            while (!dirKeyStack.isEmpty()) {
                String currentDirKey = (String)dirKeyStack.pop();
                OmDirectoryInfo currentDir = (OmDirectoryInfo)this.directoryTable.get((Object)currentDirKey);
                if (currentDir == null) {
                    if (!FSORepairTool.this.isVerbose()) continue;
                    FSORepairTool.this.info("Directory key" + currentDirKey + "to be processed was not found in the directory table.", new Object[0]);
                    continue;
                }
                childDirs = this.getChildDirectoriesAndMarkAsReachable(volume, bucket, (WithObjectID)currentDir);
                dirKeyStack.addAll(childDirs);
            }
        }

        private void markUnreachableObjectsInBucket(OmVolumeArgs volume, OmBucketInfo bucket) throws IOException {
            Stack<String> dirKeyStack = new Stack<String>();
            String bucketPrefix = "/" + volume.getObjectID() + "/" + bucket.getObjectID();
            try (Table.KeyValueIterator deletedDirIterator = this.deletedDirectoryTable.iterator();){
                deletedDirIterator.seek((Object)bucketPrefix);
                while (deletedDirIterator.hasNext()) {
                    Table.KeyValue deletedDirEntry = (Table.KeyValue)deletedDirIterator.next();
                    String deletedDirKey = (String)deletedDirEntry.getKey();
                    if (!deletedDirKey.startsWith(bucketPrefix)) {
                        break;
                    }
                    OmKeyInfo deletedDirInfo = (OmKeyInfo)deletedDirEntry.getValue();
                    long deletedObjectID = deletedDirInfo.getObjectID();
                    String childPrefix = "/" + volume.getObjectID() + "/" + bucket.getObjectID() + "/" + deletedObjectID + "/";
                    Collection<String> childDirs = this.getChildDirectoriesAndMarkAsUnreachable(childPrefix);
                    dirKeyStack.addAll(childDirs);
                }
            }
            while (!dirKeyStack.isEmpty()) {
                String currentDirKey = (String)dirKeyStack.pop();
                OmDirectoryInfo currentDir = (OmDirectoryInfo)this.directoryTable.get((Object)currentDirKey);
                if (currentDir == null) {
                    if (!FSORepairTool.this.isVerbose()) continue;
                    FSORepairTool.this.info("Directory key" + currentDirKey + "to be processed was not found in the directory table.", new Object[0]);
                    continue;
                }
                String childPrefix = "/" + volume.getObjectID() + "/" + bucket.getObjectID() + "/" + currentDir.getObjectID() + "/";
                Collection<String> childDirs = this.getChildDirectoriesAndMarkAsUnreachable(childPrefix);
                dirKeyStack.addAll(childDirs);
            }
        }

        private void handleUnreachableAndUnreferencedObjects(OmVolumeArgs volume, OmBucketInfo bucket) throws IOException {
            String bucketPrefix = "/" + volume.getObjectID() + "/" + bucket.getObjectID();
            try (Table.KeyValueIterator dirIterator = this.directoryTable.iterator();){
                dirIterator.seek((Object)bucketPrefix);
                while (dirIterator.hasNext()) {
                    Table.KeyValue dirEntry = (Table.KeyValue)dirIterator.next();
                    String dirKey = (String)dirEntry.getKey();
                    if (!dirKey.startsWith(bucketPrefix)) {
                        break;
                    }
                    if (this.isReachable(dirKey) || this.isUnreachable(dirKey)) continue;
                    this.unreferencedStats.addDir();
                    FSORepairTool.this.info("Deleting unreferenced directory " + dirKey, new Object[0]);
                    if (FSORepairTool.this.isDryRun()) continue;
                    OmDirectoryInfo dirInfo = (OmDirectoryInfo)dirEntry.getValue();
                    this.markDirectoryForDeletion(volume.getVolume(), bucket.getBucketName(), dirKey, dirInfo);
                }
            }
            try (Table.KeyValueIterator fileIterator = this.fileTable.iterator();){
                fileIterator.seek((Object)bucketPrefix);
                while (fileIterator.hasNext()) {
                    Table.KeyValue fileEntry = (Table.KeyValue)fileIterator.next();
                    String fileKey = (String)fileEntry.getKey();
                    if (!fileKey.startsWith(bucketPrefix)) {
                        break;
                    }
                    OmKeyInfo fileInfo = (OmKeyInfo)fileEntry.getValue();
                    if (!this.isReachable(fileKey)) {
                        if (this.isUnreachable(fileKey)) continue;
                        this.unreferencedStats.addFile(fileInfo.getDataSize());
                        FSORepairTool.this.info("Deleting unreferenced file " + fileKey, new Object[0]);
                        if (FSORepairTool.this.isDryRun()) continue;
                        this.markFileForDeletion(bucket, fileKey, fileInfo);
                        continue;
                    }
                    this.reachableStats.addFile(fileInfo.getDataSize());
                }
            }
        }

        protected void markFileForDeletion(OmBucketInfo bucketInfo, String fileKey, OmKeyInfo fileInfo) throws IOException {
            try (BatchOperation batch = this.store.initBatchOperation();){
                this.fileTable.deleteWithBatch(batch, (Object)fileKey);
                RepeatedOmKeyInfo originalRepeatedKeyInfo = (RepeatedOmKeyInfo)this.deletedTable.get((Object)fileKey);
                RepeatedOmKeyInfo updatedRepeatedOmKeyInfo = OmUtils.prepareKeyForDelete((long)bucketInfo.getObjectID(), (OmKeyInfo)fileInfo, (long)fileInfo.getUpdateID());
                this.deletedTable.putWithBatch(batch, (Object)fileKey, (Object)updatedRepeatedOmKeyInfo);
                if (FSORepairTool.this.isVerbose()) {
                    FSORepairTool.this.info("Added entry " + fileKey + " to open key table: " + updatedRepeatedOmKeyInfo, new Object[0]);
                }
                this.store.commitBatchOperation(batch);
            }
        }

        protected void markDirectoryForDeletion(String volumeName, String bucketName, String dirKeyName, OmDirectoryInfo dirInfo) throws IOException {
            try (BatchOperation batch = this.store.initBatchOperation();){
                this.directoryTable.deleteWithBatch(batch, (Object)dirKeyName);
                String deleteDirKeyName = dirKeyName + "/" + dirInfo.getObjectID();
                OmKeyInfo dirAsKeyInfo = OMFileRequest.getOmKeyInfo((String)volumeName, (String)bucketName, (OmDirectoryInfo)dirInfo, (String)dirInfo.getName());
                this.deletedDirectoryTable.putWithBatch(batch, (Object)deleteDirKeyName, (Object)dirAsKeyInfo);
                this.store.commitBatchOperation(batch);
            }
        }

        private Collection<String> getChildDirectoriesAndMarkAsReachable(OmVolumeArgs volume, OmBucketInfo bucket, WithObjectID currentDir) throws IOException {
            ArrayList<String> childDirs = new ArrayList<String>();
            try (Table.KeyValueIterator dirIterator = this.directoryTable.iterator();){
                String dirPrefix = FSORepairTool.buildReachableKey(volume, bucket, currentDir);
                dirIterator.seek((Object)dirPrefix);
                while (dirIterator.hasNext()) {
                    Table.KeyValue childDirEntry = (Table.KeyValue)dirIterator.next();
                    String childDirKey = (String)childDirEntry.getKey();
                    if (!childDirKey.startsWith(dirPrefix)) {
                        break;
                    }
                    this.addReachableEntry(volume, bucket, (WithObjectID)childDirEntry.getValue());
                    childDirs.add(childDirKey);
                    this.reachableStats.addDir();
                }
            }
            return childDirs;
        }

        private Collection<String> getChildDirectoriesAndMarkAsUnreachable(String dirPrefix) throws IOException {
            String relativePath;
            ArrayList<String> childDirs = new ArrayList<String>();
            try (Table.KeyValueIterator dirIterator = this.directoryTable.iterator();){
                dirIterator.seek((Object)dirPrefix);
                while (dirIterator.hasNext()) {
                    Table.KeyValue childDirEntry = (Table.KeyValue)dirIterator.next();
                    String childDirKey = (String)childDirEntry.getKey();
                    if (!childDirKey.startsWith(dirPrefix)) {
                        break;
                    }
                    relativePath = childDirKey.substring(dirPrefix.length());
                    if (relativePath.contains("/")) continue;
                    this.addUnreachableEntry(childDirKey);
                    childDirs.add(childDirKey);
                    this.unreachableStats.addDir();
                }
            }
            try (Table.KeyValueIterator fileIterator = this.fileTable.iterator();){
                fileIterator.seek((Object)dirPrefix);
                while (fileIterator.hasNext()) {
                    Table.KeyValue childFileEntry = (Table.KeyValue)fileIterator.next();
                    String childFileKey = (String)childFileEntry.getKey();
                    if (!childFileKey.startsWith(dirPrefix)) {
                        break;
                    }
                    relativePath = childFileKey.substring(dirPrefix.length());
                    if (relativePath.contains("/")) continue;
                    this.addUnreachableEntry(childFileKey);
                    this.unreachableStats.addFile(((OmKeyInfo)childFileEntry.getValue()).getDataSize());
                }
            }
            return childDirs;
        }

        private void addReachableEntry(OmVolumeArgs volume, OmBucketInfo bucket, WithObjectID object) throws IOException {
            String reachableKey = FSORepairTool.buildReachableKey(volume, bucket, object);
            this.reachableTable.put((Object)reachableKey, (Object)EMPTY_BYTE_ARRAY);
        }

        private void addUnreachableEntry(String originalKey) throws IOException {
            this.unreachableTable.put((Object)originalKey, (Object)EMPTY_BYTE_ARRAY);
        }

        protected boolean isReachable(String fileOrDirKey) throws IOException {
            String reachableParentKey = FSORepairTool.buildReachableParentKey(fileOrDirKey);
            return this.reachableTable.get((Object)reachableParentKey) != null;
        }

        protected boolean isUnreachable(String fileOrDirKey) throws IOException {
            return this.unreachableTable.get((Object)fileOrDirKey) != null;
        }

        private void openTempDB() throws IOException {
            File tempDBFile = new File(new File(FSORepairTool.this.omDBPath).getParentFile(), "temp.db");
            FSORepairTool.this.info("Creating database with reachable and unreachable tables at " + tempDBFile, new Object[0]);
            if (tempDBFile.exists()) {
                FileUtils.deleteDirectory((File)tempDBFile);
            }
            OzoneConfiguration conf = new OzoneConfiguration();
            this.tempDB = DBStoreBuilder.newBuilder((ConfigurationSource)conf).setName("temp.db").setPath(tempDBFile.getParentFile().toPath()).addTable(FSORepairTool.REACHABLE_TABLE).addTable(FSORepairTool.UNREACHABLE_TABLE).build();
            this.reachableTable = this.tempDB.getTable(FSORepairTool.REACHABLE_TABLE, (Codec)StringCodec.get(), ByteArrayCodec.get());
            this.unreachableTable = this.tempDB.getTable(FSORepairTool.UNREACHABLE_TABLE, (Codec)StringCodec.get(), ByteArrayCodec.get());
        }

        private void closeTempDB() throws IOException {
            File tempDBFile;
            if (this.tempDB != null) {
                this.tempDB.close();
            }
            if ((tempDBFile = new File(new File(FSORepairTool.this.omDBPath).getParentFile(), "temp.db")).exists()) {
                FileUtils.deleteDirectory((File)tempDBFile);
            }
        }
    }

    public static class Report {
        private final ReportStatistics reachable;
        private final ReportStatistics unreachable;
        private final ReportStatistics unreferenced;

        public Report(Report ... reports) {
            this.reachable = new ReportStatistics();
            this.unreachable = new ReportStatistics();
            this.unreferenced = new ReportStatistics();
            for (Report report : reports) {
                this.reachable.add(report.reachable);
                this.unreachable.add(report.unreachable);
                this.unreferenced.add(report.unreferenced);
            }
        }

        private Report(Builder builder) {
            this.reachable = builder.reachable;
            this.unreachable = builder.unreachable;
            this.unreferenced = builder.unreferenced;
        }

        public ReportStatistics getReachable() {
            return this.reachable;
        }

        public ReportStatistics getUnreachable() {
            return this.unreachable;
        }

        public ReportStatistics getUnreferenced() {
            return this.unreferenced;
        }

        public String toString() {
            return "Reachable:" + this.reachable + "\nUnreachable (Pending to delete):" + this.unreachable + "\nUnreferenced (Orphaned):" + this.unreferenced;
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            Report report = (Report)other;
            System.out.println("Comparing reports\nExpect:\n" + this + "\nActual:\n" + report);
            return this.reachable.equals(report.reachable) && this.unreachable.equals(report.unreachable) && this.unreferenced.equals(report.unreferenced);
        }

        public int hashCode() {
            return Objects.hash(this.reachable, this.unreachable, this.unreferenced);
        }

        public static final class Builder {
            private ReportStatistics reachable = new ReportStatistics();
            private ReportStatistics unreachable = new ReportStatistics();
            private ReportStatistics unreferenced = new ReportStatistics();

            public Builder setReachable(ReportStatistics reachable) {
                this.reachable = reachable;
                return this;
            }

            public Builder setUnreachable(ReportStatistics unreachable) {
                this.unreachable = unreachable;
                return this;
            }

            public Builder setUnreferenced(ReportStatistics unreferenced) {
                this.unreferenced = unreferenced;
                return this;
            }

            public Report build() {
                return new Report(this);
            }
        }
    }

    public static class ReportStatistics {
        private long dirs;
        private long files;
        private long bytes;

        public ReportStatistics() {
        }

        public ReportStatistics(long dirs, long files, long bytes) {
            this.dirs = dirs;
            this.files = files;
            this.bytes = bytes;
        }

        public void add(ReportStatistics other) {
            this.dirs += other.dirs;
            this.files += other.files;
            this.bytes += other.bytes;
        }

        public long getDirs() {
            return this.dirs;
        }

        public long getFiles() {
            return this.files;
        }

        public long getBytes() {
            return this.bytes;
        }

        public String toString() {
            return "\n\tDirectories: " + this.dirs + "\n\tFiles: " + this.files + "\n\tBytes: " + this.bytes;
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            ReportStatistics stats = (ReportStatistics)other;
            return this.bytes == stats.bytes && this.files == stats.files && this.dirs == stats.dirs;
        }

        public int hashCode() {
            return Objects.hash(this.bytes, this.files, this.dirs);
        }

        public void addDir() {
            ++this.dirs;
        }

        public void addFile(long size) {
            ++this.files;
            this.bytes += size;
        }
    }
}

