/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.repair.om.quota;

import java.util.concurrent.Callable;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.ozone.om.protocolPB.OzoneManagerProtocolClientSideTranslatorPB;
import org.apache.hadoop.ozone.repair.ReadOnlyCommand;
import org.apache.hadoop.ozone.repair.om.quota.QuotaRepair;
import picocli.CommandLine;

@CommandLine.Command(name="status", description={"CLI to get the status of last trigger quota repair if available."}, mixinStandardHelpOptions=true, versionProvider=HddsVersionProvider.class)
public class QuotaStatus
implements Callable<Void>,
ReadOnlyCommand {
    @CommandLine.Option(names={"--service-id", "--om-service-id"}, description={"Ozone Manager Service ID"}, required=false)
    private String omServiceId;
    @CommandLine.Option(names={"--service-host"}, description={"Ozone Manager Host. If OM HA is enabled, use --service-id instead. If you must use --service-host with OM HA, this must point directly to the leader OM. This option is required when --service-id is not provided or when HA is not enabled."})
    private String omHost;
    @CommandLine.ParentCommand
    private QuotaRepair parent;

    @Override
    public Void call() throws Exception {
        try (OzoneManagerProtocolClientSideTranslatorPB omClient = this.parent.createOmClient(this.omServiceId, this.omHost, false);){
            System.out.println(omClient.getQuotaRepairStatus());
        }
        return null;
    }
}

