/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.s3.util;

import java.util.regex.Matcher;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.ozone.s3.util.RangeHeader;
import org.apache.hadoop.ozone.s3.util.S3Consts;

@InterfaceAudience.Private
public final class RangeHeaderParserUtil {
    private RangeHeaderParserUtil() {
    }

    public static RangeHeader parseRangeHeader(String rangeHeaderVal, long length) {
        long start = 0L;
        long end = 0L;
        boolean noStart = false;
        boolean readFull = false;
        boolean inValidRange = false;
        Matcher matcher = S3Consts.RANGE_HEADER_MATCH_PATTERN.matcher(rangeHeaderVal);
        if (matcher.matches()) {
            if (!matcher.group("start").equals("")) {
                start = Long.parseLong(matcher.group("start"));
            } else {
                noStart = true;
            }
            end = !matcher.group("end").equals("") ? Long.parseLong(matcher.group("end")) : length - 1L;
            if (noStart) {
                start = end < length ? length - end : 0L;
                end = length - 1L;
            } else if (start >= length) {
                readFull = true;
                if (end >= length) {
                    inValidRange = true;
                } else {
                    start = 0L;
                    end = length - 1L;
                }
            } else if (end >= length) {
                end = length - 1L;
            }
        } else {
            start = 0L;
            end = length - 1L;
            readFull = true;
        }
        RangeHeader rangeHeader = new RangeHeader(start, end, readFull, inValidRange);
        return rangeHeader;
    }
}

