/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon;

import java.util.concurrent.atomic.AtomicBoolean;

public final class ReconConstants {
    public static final String RECON_CONTAINER_KEY_DB = "recon-container-key.db";
    public static final String CONTAINER_COUNT_KEY = "containerCount";
    public static final String RECON_OM_SNAPSHOT_DB = "om.snapshot.db";
    public static final String RECON_SCM_SNAPSHOT_DB = "scm.snapshot.db";
    public static final int DISK_USAGE_TOP_RECORDS_LIMIT = 30;
    public static final String DEFAULT_OPEN_KEY_INCLUDE_NON_FSO = "false";
    public static final String DEFAULT_OPEN_KEY_INCLUDE_FSO = "false";
    public static final String DEFAULT_FETCH_COUNT = "1000";
    public static final String DEFAULT_KEY_SIZE = "0";
    public static final String DEFAULT_BATCH_NUMBER = "1";
    public static final String RECON_QUERY_BATCH_PARAM = "batchNum";
    public static final String RECON_QUERY_PREVKEY = "prevKey";
    public static final String RECON_QUERY_START_PREFIX = "startPrefix";
    public static final String RECON_QUERY_MAX_CONTAINER_ID = "maxContainerId";
    public static final String RECON_QUERY_MIN_CONTAINER_ID = "minContainerId";
    public static final String RECON_OPEN_KEY_INCLUDE_NON_FSO = "includeNonFso";
    public static final String RECON_OPEN_KEY_INCLUDE_FSO = "includeFso";
    public static final String RECON_OM_INSIGHTS_DEFAULT_START_PREFIX = "/";
    public static final String RECON_OM_INSIGHTS_DEFAULT_SEARCH_LIMIT = "1000";
    public static final String RECON_OM_INSIGHTS_DEFAULT_SEARCH_PREV_KEY = "";
    public static final String RECON_QUERY_FILTER = "missingIn";
    public static final String PREV_CONTAINER_ID_DEFAULT_VALUE = "0";
    public static final String PREV_DELETED_BLOCKS_TRANSACTION_ID_DEFAULT_VALUE = "0";
    public static final String DEFAULT_FILTER_FOR_MISSING_CONTAINERS = "SCM";
    public static final String RECON_QUERY_LIMIT = "limit";
    public static final String RECON_QUERY_VOLUME = "volume";
    public static final String RECON_QUERY_BUCKET = "bucket";
    public static final String RECON_QUERY_FILE_SIZE = "fileSize";
    public static final String RECON_QUERY_CONTAINER_SIZE = "containerSize";
    public static final String RECON_ENTITY_PATH = "path";
    public static final String RECON_ENTITY_TYPE = "entityType";
    public static final String RECON_ACCESS_METADATA_START_DATE = "startDate";
    public static final String CONTAINER_COUNT = "CONTAINER_COUNT";
    public static final String TOTAL_KEYS = "TOTAL_KEYS";
    public static final String TOTAL_USED_BYTES = "TOTAL_USED_BYTES";
    public static final String STAGING = ".staging_";
    public static final long MAX_FILE_SIZE_UPPER_BOUND = 0x4000000000000L;
    public static final long MIN_FILE_SIZE_UPPER_BOUND = 1024L;
    public static final int NUM_OF_FILE_SIZE_BINS = (int)Math.ceil(Math.log(1.099511627776E12) / Math.log(2.0)) + 1;
    public static final long MAX_CONTAINER_SIZE_UPPER_BOUND = 0x4000000000000L;
    public static final long MIN_CONTAINER_SIZE_UPPER_BOUND = 0x20000000L;
    public static final int NUM_OF_CONTAINER_SIZE_BINS = (int)Math.ceil(Math.log(2097152.0) / Math.log(2.0)) + 1;
    public static final AtomicBoolean FILE_SIZE_COUNT_TABLE_TRUNCATED = new AtomicBoolean(false);
    public static final AtomicBoolean CONTAINER_KEY_TABLES_TRUNCATED = new AtomicBoolean(false);

    private ReconConstants() {
    }

    public static void resetTableTruncatedFlags() {
        FILE_SIZE_COUNT_TABLE_TRUNCATED.set(false);
        CONTAINER_KEY_TABLES_TRUNCATED.set(false);
    }
}

