/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.api.filters;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.security.AuthenticationFilterInitializer;
import org.apache.hadoop.security.authentication.server.AuthenticationFilter;
import org.apache.hadoop.security.authentication.server.ProxyUserAuthenticationFilter;
import org.eclipse.jetty.servlet.FilterHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ReconAuthFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(ReconAuthFilter.class);
    private final OzoneConfiguration conf;
    private ProxyUserAuthenticationFilter hadoopAuthFilter;

    @Inject
    ReconAuthFilter(OzoneConfiguration conf) {
        this.conf = conf;
    }

    public void init(final FilterConfig filterConfig) throws ServletException {
        this.hadoopAuthFilter = new ProxyUserAuthenticationFilter();
        Map parameters = AuthenticationFilterInitializer.getFilterConfigMap((Configuration)this.conf, (String)"ozone.recon.http.auth.");
        final FilterHolder filterHolder = ReconAuthFilter.getFilterHolder("authentication", AuthenticationFilter.class.getName(), parameters);
        this.hadoopAuthFilter.init(new FilterConfig(){

            public String getFilterName() {
                return filterHolder.getName();
            }

            public ServletContext getServletContext() {
                return filterConfig.getServletContext();
            }

            public String getInitParameter(String s) {
                return filterHolder.getInitParameter(s);
            }

            public Enumeration<String> getInitParameterNames() {
                return filterHolder.getInitParameterNames();
            }
        });
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Filtering request to {} through authentication filter.", (Object)((HttpServletRequest)servletRequest).getRequestURL());
        }
        this.hadoopAuthFilter.doFilter(servletRequest, servletResponse, filterChain);
    }

    private static FilterHolder getFilterHolder(String name, String classname, Map<String, String> parameters) {
        FilterHolder holder = new FilterHolder();
        holder.setName(name);
        holder.setClassName(classname);
        if (parameters != null) {
            holder.setInitParameters(parameters);
        }
        return holder;
    }

    public void destroy() {
    }
}

