/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.spi.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterators;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.MutableConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.server.http.HttpConfig;
import org.apache.hadoop.hdds.utils.db.DBCheckpoint;
import org.apache.hadoop.hdds.utils.db.RDBBatchOperation;
import org.apache.hadoop.hdds.utils.db.RDBStore;
import org.apache.hadoop.hdds.utils.db.RocksDBCheckpoint;
import org.apache.hadoop.hdds.utils.db.RocksDatabase;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.hdds.utils.db.managed.ManagedWriteBatch;
import org.apache.hadoop.hdds.utils.db.managed.ManagedWriteOptions;
import org.apache.hadoop.hdfs.web.URLConnectionFactory;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.helpers.DBUpdates;
import org.apache.hadoop.ozone.om.helpers.ServiceInfo;
import org.apache.hadoop.ozone.om.protocol.OzoneManagerProtocol;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.recon.ReconContext;
import org.apache.hadoop.ozone.recon.ReconUtils;
import org.apache.hadoop.ozone.recon.TarExtractor;
import org.apache.hadoop.ozone.recon.metrics.OzoneManagerSyncMetrics;
import org.apache.hadoop.ozone.recon.metrics.ReconSyncMetrics;
import org.apache.hadoop.ozone.recon.recovery.ReconOMMetadataManager;
import org.apache.hadoop.ozone.recon.spi.OzoneManagerServiceProvider;
import org.apache.hadoop.ozone.recon.tasks.OMDBUpdatesHandler;
import org.apache.hadoop.ozone.recon.tasks.ReconOmTask;
import org.apache.hadoop.ozone.recon.tasks.ReconTaskController;
import org.apache.hadoop.ozone.recon.tasks.ReconTaskReInitializationEvent;
import org.apache.hadoop.ozone.recon.tasks.updater.ReconTaskStatusUpdater;
import org.apache.hadoop.ozone.recon.tasks.updater.ReconTaskStatusUpdaterManager;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.util.Time;
import org.apache.ratis.proto.RaftProtos;
import org.rocksdb.RocksDBException;
import org.rocksdb.WriteBatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class OzoneManagerServiceProviderImpl
implements OzoneManagerServiceProvider {
    private static final Logger LOG = LoggerFactory.getLogger(OzoneManagerServiceProviderImpl.class);
    private URLConnectionFactory connectionFactory;
    private File omSnapshotDBParentDir = null;
    private File reconDbDir = null;
    private String omDBSnapshotUrl;
    private OzoneManagerProtocol ozoneManagerClient;
    private final OzoneConfiguration configuration;
    private ScheduledExecutorService scheduler;
    private ReconOMMetadataManager omMetadataManager;
    private ReconTaskController reconTaskController;
    private ReconUtils reconUtils;
    private OzoneManagerSyncMetrics metrics;
    private ReconSyncMetrics reconSyncMetrics;
    private final long deltaUpdateLimit;
    private final long omDBLagThreshold;
    private AtomicBoolean isSyncDataFromOMRunning;
    private final String threadNamePrefix;
    private ThreadFactory threadFactory;
    private ReconContext reconContext;
    private ReconTaskStatusUpdaterManager taskStatusUpdaterManager;
    private TarExtractor tarExtractor;

    @Inject
    public OzoneManagerServiceProviderImpl(OzoneConfiguration configuration, ReconOMMetadataManager omMetadataManager, ReconTaskController reconTaskController, ReconUtils reconUtils, OzoneManagerProtocol ozoneManagerClient, ReconContext reconContext, ReconTaskStatusUpdaterManager taskStatusUpdaterManager) {
        boolean flushParam;
        int connectionTimeout = (int)configuration.getTimeDuration("ozone.recon.om.connection.timeout", configuration.get("recon.om.connection.timeout", "5s"), TimeUnit.MILLISECONDS);
        int connectionRequestTimeout = (int)configuration.getTimeDuration("ozone.recon.om.connection.request.timeout", configuration.get("recon.om.connection.request.timeout", "5s"), TimeUnit.MILLISECONDS);
        this.connectionFactory = URLConnectionFactory.newDefaultURLConnectionFactory((int)connectionTimeout, (int)connectionRequestTimeout, (Configuration)configuration);
        String ozoneManagerHttpAddress = configuration.get("ozone.om.http-address");
        String ozoneManagerHttpsAddress = configuration.get("ozone.om.https-address");
        long deltaUpdateLimits = configuration.getLong("recon.om.delta.update.limit", 50000L);
        this.omSnapshotDBParentDir = reconUtils.getReconDbDir((ConfigurationSource)configuration, "ozone.recon.om.db.dir");
        this.reconDbDir = reconUtils.getReconDbDir((ConfigurationSource)configuration, "ozone.recon.db.dir");
        HttpConfig.Policy policy = HttpConfig.getHttpPolicy((MutableConfigurationSource)configuration);
        this.omDBSnapshotUrl = "http://" + ozoneManagerHttpAddress + "/dbCheckpoint";
        if (policy.isHttpsEnabled()) {
            this.omDBSnapshotUrl = "https://" + ozoneManagerHttpsAddress + "/dbCheckpoint";
        }
        if (flushParam = configuration.getBoolean("ozone.recon.om.snapshot.task.flush.param", configuration.getBoolean("recon.om.snapshot.task.flush.param", false))) {
            this.omDBSnapshotUrl = this.omDBSnapshotUrl + "?flushBeforeCheckpoint=true";
        }
        this.reconUtils = reconUtils;
        this.omMetadataManager = omMetadataManager;
        this.reconTaskController = reconTaskController;
        this.ozoneManagerClient = ozoneManagerClient;
        this.configuration = configuration;
        this.metrics = OzoneManagerSyncMetrics.create();
        this.reconSyncMetrics = ReconSyncMetrics.create();
        this.deltaUpdateLimit = deltaUpdateLimits;
        this.isSyncDataFromOMRunning = new AtomicBoolean();
        this.threadNamePrefix = reconUtils.getReconNodeDetails(configuration).threadNamePrefix();
        this.threadFactory = new ThreadFactoryBuilder().setNameFormat(this.threadNamePrefix + "SyncOM-%d").build();
        int omDBTarProcessorThreadCount = Math.max(64, Runtime.getRuntime().availableProcessors());
        this.reconContext = reconContext;
        this.taskStatusUpdaterManager = taskStatusUpdaterManager;
        this.omDBLagThreshold = configuration.getLong("recon.om.delta.update.lag.threshold", 0L);
        this.tarExtractor = new TarExtractor(omDBTarProcessorThreadCount, this.threadNamePrefix);
    }

    @Override
    public OMMetadataManager getOMMetadataManagerInstance() {
        return this.omMetadataManager;
    }

    @Override
    public void start() {
        LOG.info("Starting Ozone Manager Service Provider.");
        this.scheduler = Executors.newScheduledThreadPool(1, this.threadFactory);
        try {
            this.tarExtractor.start();
            this.omMetadataManager.start(this.configuration);
        }
        catch (IOException ioEx) {
            LOG.error("Error starting Recon OM Metadata Manager.", (Throwable)ioEx);
            this.reconContext.updateHealthStatus(new AtomicBoolean(false));
            this.reconContext.updateErrors(ReconContext.ErrorCode.INTERNAL_ERROR);
        }
        catch (RuntimeException runtimeException) {
            LOG.warn("Unexpected runtime error starting Recon OM Metadata Manager.", (Throwable)runtimeException);
            LOG.warn("Trying to delete existing recon OM snapshot DB and fetch new one.");
            this.metrics.incrNumSnapshotRequests();
            LOG.info("Fetching full snapshot from Ozone Manager");
            try {
                boolean success = this.updateReconOmDBWithNewSnapshot();
                if (success) {
                    LOG.info("Successfully fetched a full snapshot from Ozone Manager");
                } else {
                    LOG.error("Failed fetching a full snapshot from Ozone Manager");
                }
            }
            catch (IOException e) {
                LOG.error("Unexpected IOException occurred while trying to fetch a full snapshot", (Throwable)e);
                throw new RuntimeException(runtimeException);
            }
        }
        this.reconTaskController.start();
        long initialDelay = this.configuration.getTimeDuration("ozone.recon.om.snapshot.task.initial.delay", this.configuration.get("recon.om.snapshot.task.initial.delay", "1m"), TimeUnit.MILLISECONDS);
        this.reconTaskController.getRegisteredTasks().values().forEach(ReconOmTask::init);
        ReconTaskStatusUpdater deltaTaskStatusUpdater = this.taskStatusUpdaterManager.getTaskStatusUpdater(OmSnapshotTaskName.OmDeltaRequest.name());
        ReconTaskStatusUpdater fullSnapshotReconTaskUpdater = this.taskStatusUpdaterManager.getTaskStatusUpdater(OmSnapshotTaskName.OmSnapshotRequest.name());
        Map<String, ReconOmTask> reconOmTaskMap = this.reconTaskController.getRegisteredTasks().entrySet().stream().filter(entry -> {
            String taskName = (String)entry.getKey();
            ReconTaskStatusUpdater taskStatusUpdater = this.taskStatusUpdaterManager.getTaskStatusUpdater(taskName);
            return !taskName.equals(OmSnapshotTaskName.OmDeltaRequest.name()) && !taskName.equals(OmSnapshotTaskName.OmSnapshotRequest.name()) && taskStatusUpdater.getLastUpdatedSeqNumber().compareTo(deltaTaskStatusUpdater.getLastUpdatedSeqNumber()) < 0;
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        if (!reconOmTaskMap.isEmpty()) {
            LOG.info("Task name and last updated sequence number of tasks, that are not matching with the last updated sequence number of OmDeltaRequest task:\n");
            LOG.info("{} -> {}", (Object)deltaTaskStatusUpdater.getTaskName(), (Object)deltaTaskStatusUpdater.getLastUpdatedSeqNumber());
            reconOmTaskMap.keySet().forEach(taskName -> LOG.info("{} -> {}", taskName, (Object)this.taskStatusUpdaterManager.getTaskStatusUpdater((String)taskName).getLastUpdatedSeqNumber()));
            LOG.info("Re-initializing all tasks again (not just above failed delta tasks) based on updated OM DB snapshot and last updated sequence number because fresh staging DB needs to be created for all tasks.");
            LOG.info("Queueing async reinitialization events during startup.");
            ReconTaskController.ReInitializationResult result = this.reconTaskController.queueReInitializationEvent(ReconTaskReInitializationEvent.ReInitializationReason.MANUAL_TRIGGER);
            if (result != ReconTaskController.ReInitializationResult.SUCCESS) {
                LOG.error("Failed to queue reinitialization event for manual trigger at startup (result: {}), failing the snapshot operation", (Object)result);
                this.metrics.incrNumSnapshotRequestsFailed();
                fullSnapshotReconTaskUpdater.setLastTaskRunStatus(-1);
                fullSnapshotReconTaskUpdater.recordRunCompletion();
                this.reconContext.updateHealthStatus(new AtomicBoolean(false));
                this.reconContext.updateErrors(ReconContext.ErrorCode.GET_OM_DB_SNAPSHOT_FAILED);
                throw new RuntimeException("Failed to queue reinitialization event for manual trigger at startup");
            }
        }
        this.startSyncDataFromOM(initialDelay);
        LOG.info("Ozone Manager Service Provider is started.");
    }

    private void startSyncDataFromOM(long initialDelay) {
        long interval = this.configuration.getTimeDuration("ozone.recon.om.snapshot.task.interval.delay", this.configuration.get("recon.om.snapshot.task.interval.delay", "5s"), TimeUnit.MILLISECONDS);
        LOG.debug("Started the OM DB sync scheduler.");
        this.scheduler.scheduleWithFixedDelay(() -> {
            try {
                LOG.info("Last known sequence number before sync: {}", (Object)this.getCurrentOMDBSequenceNumber());
                boolean isSuccess = this.syncDataFromOM();
                if (!isSuccess) {
                    LOG.debug("OM DB sync is already running, or encountered an error while trying to sync data.");
                }
                LOG.info("Sequence number after sync: {}", (Object)this.getCurrentOMDBSequenceNumber());
            }
            catch (Throwable t) {
                LOG.error("Unexpected exception while syncing data from OM.", t);
            }
        }, initialDelay, interval, TimeUnit.MILLISECONDS);
    }

    private void stopSyncDataFromOMThread() {
        this.scheduler.shutdownNow();
        this.tarExtractor.stop();
        LOG.debug("Shutdown the OM DB sync scheduler.");
    }

    @Override
    public boolean triggerSyncDataFromOMImmediately() {
        if (!this.isSyncDataFromOMRunning.get()) {
            this.stopSyncDataFromOMThread();
            this.scheduler = Executors.newScheduledThreadPool(1, this.threadFactory);
            this.tarExtractor.start();
            this.startSyncDataFromOM(0L);
            return true;
        }
        LOG.info("OM DB sync is already running when trying to trigger OM DB sync manually.");
        return false;
    }

    @Override
    public void stop() throws Exception {
        LOG.info("Stopping Ozone Manager Service Provider.");
        this.reconTaskController.stop();
        this.omMetadataManager.stop();
        this.scheduler.shutdownNow();
        this.tarExtractor.stop();
        this.metrics.unRegister();
        this.reconSyncMetrics.unRegister();
        this.connectionFactory.destroy();
    }

    @VisibleForTesting
    public String getOzoneManagerSnapshotUrl() throws IOException {
        String omLeaderUrl = this.omDBSnapshotUrl;
        List serviceList = this.ozoneManagerClient.getServiceList();
        HttpConfig.Policy policy = HttpConfig.getHttpPolicy((MutableConfigurationSource)this.configuration);
        if (!serviceList.isEmpty()) {
            for (ServiceInfo info : serviceList) {
                if (!info.getNodeType().equals((Object)HddsProtos.NodeType.OM) || !info.getOmRoleInfo().hasServerRole() || !info.getOmRoleInfo().getServerRole().equals(RaftProtos.RaftPeerRole.LEADER.name())) continue;
                omLeaderUrl = (policy.isHttpsEnabled() ? "https://" + info.getServiceAddress(OzoneManagerProtocolProtos.ServicePort.Type.HTTPS) : "http://" + info.getServiceAddress(OzoneManagerProtocolProtos.ServicePort.Type.HTTP)) + "/dbCheckpoint";
            }
        }
        return omLeaderUrl;
    }

    private boolean isOmSpnegoEnabled() {
        return this.configuration.get("ozone.om.http.auth.type", "simple").equals("kerberos");
    }

    @VisibleForTesting
    public DBCheckpoint getOzoneManagerDBSnapshot() {
        File[] leftOverStagingDirs;
        String snapshotFileName = "om.snapshot.db_" + System.currentTimeMillis();
        Path untarredDbDir = Paths.get(this.omSnapshotDBParentDir.getAbsolutePath(), snapshotFileName);
        File lastKnownDB = this.reconUtils.getLastKnownDB(this.omSnapshotDBParentDir, "om.snapshot.db");
        if (lastKnownDB != null) {
            boolean existingOmSnapshotDBDeleted = FileUtils.deleteQuietly((File)lastKnownDB);
            if (existingOmSnapshotDBDeleted) {
                LOG.info("Successfully deleted existing OM DB snapshot directory: {}", (Object)lastKnownDB.getAbsolutePath());
            } else {
                LOG.warn("Failed to delete existing OM DB snapshot directory: {}", (Object)lastKnownDB.getAbsolutePath());
            }
        }
        if ((leftOverStagingDirs = this.omSnapshotDBParentDir.listFiles(f -> f.getName().startsWith(".staging_"))) != null) {
            for (File stagingDir : leftOverStagingDirs) {
                LOG.warn("Cleaning up leftover staging folder from failed extraction: {}", (Object)stagingDir.getAbsolutePath());
                boolean stagingDirDeleted = FileUtils.deleteQuietly((File)stagingDir);
                if (stagingDirDeleted) {
                    LOG.info("Successfully deleted leftover staging folder: {}", (Object)stagingDir.getAbsolutePath());
                    continue;
                }
                LOG.warn("Failed to delete leftover staging folder: {}", (Object)stagingDir.getAbsolutePath());
            }
        }
        try {
            SecurityUtil.doAsLoginUser(() -> {
                try (InputStream inputStream = this.reconUtils.makeHttpCall(this.connectionFactory, this.getOzoneManagerSnapshotUrl(), this.isOmSpnegoEnabled()).getInputStream();){
                    this.tarExtractor.extractTar(inputStream, untarredDbDir);
                }
                catch (IOException | InterruptedException e) {
                    this.reconContext.updateHealthStatus(new AtomicBoolean(false));
                    this.reconContext.updateErrors(ReconContext.ErrorCode.GET_OM_DB_SNAPSHOT_FAILED);
                    throw new RuntimeException("Error while extracting OM DB Snapshot TAR.", e);
                }
                return null;
            });
            File[] sstFiles = untarredDbDir.toFile().listFiles((dir, name) -> name.endsWith(".sst"));
            if (sstFiles != null && sstFiles.length > 0) {
                LOG.info("Number of SST files found in the OM snapshot directory: {} - {}", (Object)untarredDbDir, (Object)sstFiles.length);
            }
            List sstFileNames = Arrays.stream(sstFiles).map(File::getName).collect(Collectors.toList());
            LOG.debug("Valid SST files found: {}", sstFileNames);
            this.reconContext.updateHealthStatus(new AtomicBoolean(true));
            this.reconContext.getErrors().remove((Object)ReconContext.ErrorCode.GET_OM_DB_SNAPSHOT_FAILED);
            return new RocksDBCheckpoint(untarredDbDir);
        }
        catch (IOException e) {
            LOG.error("Unable to obtain Ozone Manager DB Snapshot.", (Throwable)e);
            this.reconContext.updateHealthStatus(new AtomicBoolean(false));
            this.reconContext.updateErrors(ReconContext.ErrorCode.GET_OM_DB_SNAPSHOT_FAILED);
            return null;
        }
    }

    @VisibleForTesting
    boolean updateReconOmDBWithNewSnapshot() throws IOException {
        this.checkAndValidateReconDbPermissions();
        this.reconSyncMetrics.incrFullDBFetchRequests();
        long startTime = Time.monotonicNow();
        DBCheckpoint dbSnapshot = this.getOzoneManagerDBSnapshot();
        long fullDBLatency = Time.monotonicNow() - startTime;
        this.reconSyncMetrics.updateFullDBRequestLatency(fullDBLatency);
        if (dbSnapshot == null) {
            LOG.error("Failed to obtain a valid DB snapshot from Ozone Manager. This could be due to missing SST files or other fetch issues.");
            this.reconSyncMetrics.incrSnapshotDownloadFailures();
            return false;
        }
        if (dbSnapshot.getCheckpointLocation() == null) {
            LOG.error("Snapshot checkpoint location is null, indicating a failure to properly fetch or store the snapshot.");
            this.reconSyncMetrics.incrSnapshotDownloadFailures();
            return false;
        }
        LOG.info("Attempting to update Recon OM DB with new snapshot located at: {}", (Object)dbSnapshot.getCheckpointLocation());
        try {
            File snapshotDir = dbSnapshot.getCheckpointLocation().toFile();
            long snapshotSize = FileUtils.sizeOfDirectory((File)snapshotDir);
            this.reconSyncMetrics.incrSnapshotSizeBytes(snapshotSize);
            this.omMetadataManager.updateOmDB(snapshotDir, true);
            this.reconSyncMetrics.incrSnapshotDownloadSuccess();
            LOG.info("Successfully updated Recon OM DB with new snapshot.");
            return true;
        }
        catch (IOException e) {
            LOG.error("Unable to refresh Recon OM DB Snapshot.", (Throwable)e);
            this.reconSyncMetrics.incrSnapshotDownloadFailures();
            return false;
        }
    }

    @VisibleForTesting
    Long getAndApplyDeltaUpdatesFromOM(long fromSequenceNumber, OMDBUpdatesHandler omdbUpdatesHandler) throws IOException, RocksDBException {
        LOG.debug("OriginalFromSequenceNumber : {} ", (Object)fromSequenceNumber);
        ImmutablePair<Boolean, Long> dbUpdatesLatestSeqNumOfOMDB = this.innerGetAndApplyDeltaUpdatesFromOM(fromSequenceNumber, omdbUpdatesHandler);
        if (!((Boolean)dbUpdatesLatestSeqNumOfOMDB.getLeft()).booleanValue()) {
            LOG.error("Retrieve OM DB delta update failed for sequence number : {}, so falling back to full snapshot.", (Object)fromSequenceNumber);
            throw new RocksDBException("Unable to get delta updates since sequenceNumber - " + fromSequenceNumber);
        }
        omdbUpdatesHandler.setLatestSequenceNumber(this.getCurrentOMDBSequenceNumber());
        return (Long)dbUpdatesLatestSeqNumOfOMDB.getRight();
    }

    @VisibleForTesting
    ImmutablePair<Boolean, Long> innerGetAndApplyDeltaUpdatesFromOM(long fromSequenceNumber, OMDBUpdatesHandler omdbUpdatesHandler) throws IOException, RocksDBException {
        long deltaFetchStartTime = Time.monotonicNow();
        OzoneManagerProtocolProtos.DBUpdatesRequest dbUpdatesRequest = OzoneManagerProtocolProtos.DBUpdatesRequest.newBuilder().setSequenceNumber(fromSequenceNumber).setLimitCount(this.deltaUpdateLimit).build();
        DBUpdates dbUpdates = this.ozoneManagerClient.getDBUpdates(dbUpdatesRequest);
        long deltaFetchDuration = Time.monotonicNow() - deltaFetchStartTime;
        this.reconSyncMetrics.updateDeltaFetchDuration(deltaFetchDuration);
        int numUpdates = 0;
        long latestSequenceNumberOfOM = -1L;
        if (null != dbUpdates && dbUpdates.getCurrentSequenceNumber() != -1L) {
            this.reconSyncMetrics.incrDeltaFetchSuccess();
            latestSequenceNumberOfOM = dbUpdates.getLatestSequenceNumber();
            RDBStore rocksDBStore = (RDBStore)this.omMetadataManager.getStore();
            RocksDatabase rocksDB = rocksDBStore.getDb();
            numUpdates = dbUpdates.getData().size();
            if (numUpdates > 0) {
                this.metrics.incrNumUpdatesInDeltaTotal(numUpdates);
                long totalDataSize = 0L;
                for (byte[] data : dbUpdates.getData()) {
                    totalDataSize += (long)data.length;
                }
                this.reconSyncMetrics.incrDeltaDataFetchSize(totalDataSize);
            }
            long deltaApplyStartTime = Time.monotonicNow();
            try {
                for (byte[] data : dbUpdates.getData()) {
                    try (ManagedWriteBatch writeBatch = new ManagedWriteBatch(data);){
                        writeBatch.iterate((WriteBatch.Handler)omdbUpdatesHandler);
                        try (RDBBatchOperation rdbBatchOperation = new RDBBatchOperation(writeBatch);
                             ManagedWriteOptions wOpts = new ManagedWriteOptions();){
                            rdbBatchOperation.commit(rocksDB, wOpts);
                        }
                    }
                }
                long deltaApplyDuration = Time.monotonicNow() - deltaApplyStartTime;
                this.reconSyncMetrics.updateDeltaApplyDuration(deltaApplyDuration);
            }
            catch (IOException | RocksDBException e) {
                this.reconSyncMetrics.incrDeltaApplyFailures();
                throw e;
            }
        } else {
            this.reconSyncMetrics.incrDeltaFetchFailures();
        }
        long lag = latestSequenceNumberOfOM == -1L ? 0L : latestSequenceNumberOfOM - this.getCurrentOMDBSequenceNumber();
        this.metrics.setSequenceNumberLag(lag);
        LOG.info("From Sequence Number:{}, Recon DB Sequence Number: {}, Number of updates received from OM : {}, SequenceNumber diff: {}, SequenceNumber Lag from OM {}, isDBUpdateSuccess: {}", new Object[]{fromSequenceNumber, this.getCurrentOMDBSequenceNumber(), numUpdates, this.getCurrentOMDBSequenceNumber() - fromSequenceNumber, lag, null != dbUpdates && dbUpdates.isDBUpdateSuccess()});
        return new ImmutablePair((Object)(null != dbUpdates && dbUpdates.isDBUpdateSuccess() ? 1 : 0), (Object)lag);
    }

    /*
     * Exception decompiling
     */
    @VisibleForTesting
    public boolean syncDataFromOM() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void markDeltaTaskStatusAsFailed(ReconTaskStatusUpdater deltaReconTaskStatusUpdater) {
        this.metrics.incrNumDeltaRequestsFailed();
        deltaReconTaskStatusUpdater.setLastTaskRunStatus(-1);
        deltaReconTaskStatusUpdater.recordRunCompletion();
    }

    private void executeFullSnapshot(ReconTaskStatusUpdater fullSnapshotReconTaskUpdater, ReconTaskStatusUpdater deltaReconTaskStatusUpdater) throws InterruptedException, IOException {
        this.metrics.incrNumSnapshotRequests();
        LOG.info("Obtaining full snapshot from Ozone Manager");
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException("Thread interrupted during snapshot sync.");
        }
        fullSnapshotReconTaskUpdater.recordRunStart();
        boolean success = this.updateReconOmDBWithNewSnapshot();
        if (success) {
            fullSnapshotReconTaskUpdater.setLastUpdatedSeqNumber(this.getCurrentOMDBSequenceNumber());
            deltaReconTaskStatusUpdater.setLastUpdatedSeqNumber(this.getCurrentOMDBSequenceNumber());
            fullSnapshotReconTaskUpdater.setLastTaskRunStatus(0);
            fullSnapshotReconTaskUpdater.recordRunCompletion();
            deltaReconTaskStatusUpdater.updateDetails();
            this.reconTaskController.updateOMMetadataManager(this.omMetadataManager);
            LOG.info("Queueing async reinitialization event instead of blocking call");
            ReconTaskController.ReInitializationResult result = this.reconTaskController.queueReInitializationEvent(ReconTaskReInitializationEvent.ReInitializationReason.MANUAL_TRIGGER);
            if (result != ReconTaskController.ReInitializationResult.SUCCESS) {
                LOG.error("Failed to queue reinitialization event for manual trigger (result: {}), failing the snapshot operation", (Object)result);
                this.metrics.incrNumSnapshotRequestsFailed();
                fullSnapshotReconTaskUpdater.setLastTaskRunStatus(-1);
                fullSnapshotReconTaskUpdater.recordRunCompletion();
                this.reconContext.updateHealthStatus(new AtomicBoolean(false));
                this.reconContext.updateErrors(ReconContext.ErrorCode.GET_OM_DB_SNAPSHOT_FAILED);
                return;
            }
            this.reconContext.updateHealthStatus(new AtomicBoolean(true));
            this.reconContext.getErrors().remove((Object)ReconContext.ErrorCode.GET_OM_DB_SNAPSHOT_FAILED);
        } else {
            this.metrics.incrNumSnapshotRequestsFailed();
            fullSnapshotReconTaskUpdater.setLastTaskRunStatus(-1);
            fullSnapshotReconTaskUpdater.recordRunCompletion();
            this.reconContext.updateHealthStatus(new AtomicBoolean(false));
            this.reconContext.updateErrors(ReconContext.ErrorCode.GET_OM_DB_SNAPSHOT_FAILED);
        }
    }

    private void printOMDBMetaInfo() {
        this.printTableCount("fileTable");
        this.printTableCount("keyTable");
    }

    private void printTableCount(String tableName) {
        Table table = this.omMetadataManager.getTable(tableName);
        if (table == null) {
            LOG.error("Table {} not found in OM Metadata.", (Object)tableName);
            return;
        }
        if (LOG.isDebugEnabled()) {
            try (Table.KeyValueIterator iterator = table.iterator();){
                long count = Iterators.size((Iterator)iterator);
                LOG.debug("{} Table count: {}", (Object)tableName, (Object)count);
            }
            catch (IOException ioException) {
                LOG.error("Unexpected error while iterating table for table count: {}", (Object)tableName);
            }
        }
    }

    public void checkAndValidateReconDbPermissions() {
        File dbDir = new File(this.reconDbDir.getPath());
        if (!dbDir.exists()) {
            LOG.error("Recon DB directory does not exist: {}", (Object)dbDir.getAbsolutePath());
            return;
        }
        try {
            String expectedPermissions = this.configuration.get("ozone.recon.db.dirs.permissions", "750");
            Set<PosixFilePermission> expectedPosixPermissions = PosixFilePermissions.fromString(ReconUtils.convertNumericToSymbolic(expectedPermissions));
            Set<PosixFilePermission> actualPermissions = Files.getPosixFilePermissions(dbDir.toPath(), new LinkOption[0]);
            String actualPermissionsStr = PosixFilePermissions.toString(actualPermissions);
            if (actualPermissions.containsAll(expectedPosixPermissions)) {
                LOG.info("Permissions for Recon DB directory '{}' meet the minimum required permissions '{}'", (Object)dbDir.getAbsolutePath(), (Object)expectedPermissions);
            } else {
                LOG.warn("Permissions for Recon DB directory '{}' are '{}', which do not meet the minimum required permissions '{}'", new Object[]{dbDir.getAbsolutePath(), actualPermissionsStr, expectedPermissions});
            }
        }
        catch (IOException e) {
            LOG.error("Failed to retrieve permissions for Recon DB directory: {}", (Object)dbDir.getAbsolutePath(), (Object)e);
        }
        catch (IllegalArgumentException e) {
            LOG.error("Configuration issue: {}", (Object)e.getMessage());
        }
    }

    @VisibleForTesting
    public long getCurrentOMDBSequenceNumber() {
        return this.omMetadataManager.getLastSequenceNumberFromDB();
    }

    public OzoneManagerSyncMetrics getMetrics() {
        return this.metrics;
    }

    @VisibleForTesting
    public TarExtractor getTarExtractor() {
        return this.tarExtractor;
    }

    private static /* synthetic */ Boolean lambda$syncDataFromOM$7() {
        LOG.error("ReInitializationResult is null, something went wrong in queueing reinitialization event");
        return true;
    }

    private static /* synthetic */ Boolean lambda$syncDataFromOM$6(ReconTaskController.ReInitializationResult r) {
        switch (r) {
            case MAX_RETRIES_EXCEEDED: {
                LOG.warn("Reinitialization queue failures exceeded maximum retries, triggering full snapshot fallback");
                return true;
            }
            case RETRY_LATER: {
                LOG.debug("Reinitialization event queueing will be retried in next iteration");
                return false;
            }
        }
        LOG.info("Reinitialization event successfully queued");
        return false;
    }

    public static enum OmSnapshotTaskName {
        OmSnapshotRequest,
        OmDeltaRequest;

    }
}

