/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.spi.impl;

import java.util.Map;
import org.apache.hadoop.hdds.utils.db.Codec;
import org.apache.hadoop.hdds.utils.db.DBColumnFamilyDefinition;
import org.apache.hadoop.hdds.utils.db.DBDefinition;
import org.apache.hadoop.hdds.utils.db.IntegerCodec;
import org.apache.hadoop.hdds.utils.db.LongCodec;
import org.apache.hadoop.hdds.utils.db.StringCodec;
import org.apache.hadoop.ozone.recon.api.types.ContainerKeyPrefix;
import org.apache.hadoop.ozone.recon.api.types.KeyPrefixContainer;
import org.apache.hadoop.ozone.recon.api.types.NSSummary;
import org.apache.hadoop.ozone.recon.codec.NSSummaryCodec;
import org.apache.hadoop.ozone.recon.scm.ContainerReplicaHistoryList;
import org.apache.hadoop.ozone.recon.spi.impl.ContainerKeyPrefixCodec;
import org.apache.hadoop.ozone.recon.spi.impl.KeyPrefixContainerCodec;
import org.apache.hadoop.ozone.recon.tasks.FileSizeCountKey;
import org.apache.hadoop.ozone.recon.tasks.GlobalStatsValue;

public class ReconDBDefinition
extends DBDefinition.WithMap {
    private final String dbName;
    public static final DBColumnFamilyDefinition<ContainerKeyPrefix, Integer> CONTAINER_KEY = new DBColumnFamilyDefinition("containerKeyTable", ContainerKeyPrefixCodec.get(), (Codec)IntegerCodec.get());
    public static final DBColumnFamilyDefinition<KeyPrefixContainer, Integer> KEY_CONTAINER = new DBColumnFamilyDefinition("keyContainerTable", KeyPrefixContainerCodec.get(), (Codec)IntegerCodec.get());
    public static final DBColumnFamilyDefinition<Long, Long> CONTAINER_KEY_COUNT = new DBColumnFamilyDefinition("containerKeyCountTable", (Codec)LongCodec.get(), (Codec)LongCodec.get());
    public static final DBColumnFamilyDefinition<Long, ContainerReplicaHistoryList> REPLICA_HISTORY = new DBColumnFamilyDefinition("replica_history", (Codec)LongCodec.get(), ContainerReplicaHistoryList.getCodec());
    public static final DBColumnFamilyDefinition<Long, NSSummary> NAMESPACE_SUMMARY = new DBColumnFamilyDefinition("namespaceSummaryTable", (Codec)LongCodec.get(), NSSummaryCodec.get());
    public static final DBColumnFamilyDefinition<Long, ContainerReplicaHistoryList> REPLICA_HISTORY_V2 = new DBColumnFamilyDefinition("replica_history_v2", (Codec)LongCodec.get(), ContainerReplicaHistoryList.getCodec());
    public static final DBColumnFamilyDefinition<FileSizeCountKey, Long> FILE_COUNT_BY_SIZE = new DBColumnFamilyDefinition("fileCountBySizeTable", FileSizeCountKey.getCodec(), (Codec)LongCodec.get());
    public static final DBColumnFamilyDefinition<String, GlobalStatsValue> GLOBAL_STATS = new DBColumnFamilyDefinition("globalStatsTable", (Codec)StringCodec.get(), GlobalStatsValue.getCodec());
    private static final Map<String, DBColumnFamilyDefinition<?, ?>> COLUMN_FAMILIES = DBColumnFamilyDefinition.newUnmodifiableMap((DBColumnFamilyDefinition[])new DBColumnFamilyDefinition[]{CONTAINER_KEY, CONTAINER_KEY_COUNT, KEY_CONTAINER, NAMESPACE_SUMMARY, REPLICA_HISTORY, REPLICA_HISTORY_V2, FILE_COUNT_BY_SIZE, GLOBAL_STATS});

    public ReconDBDefinition(String dbName) {
        super(COLUMN_FAMILIES);
        this.dbName = dbName;
    }

    public String getName() {
        return this.dbName;
    }

    public String getLocationConfigKey() {
        return "ozone.recon.db.dir";
    }
}

